/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.event;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import xaero.lib.common.config.channel.ConfigChannel;
import xaero.lib.common.config.channel.register.ConfigChannelRegistry;
import xaero.lib.common.player.IServerPlayer;
import xaero.lib.common.player.ServerPlayerData;
import xaero.lib.common.player.ServerPlayerLoginHandler;
import xaero.lib.common.player.ServerPlayerTickHandler;

public class CommonEvents {
    private final ServerPlayerTickHandler playerTickHandler = new ServerPlayerTickHandler();

    public void clonePlayer(PlayerEntity from, PlayerEntity to) {
        if (!(to instanceof IServerPlayer)) {
            return;
        }
        ((IServerPlayer)to).xaerolib_setData(((IServerPlayer)from).xaerolib_getData());
        ((IServerPlayer)to).xaerolib_getData().setPlayer((ServerPlayerEntity)to);
    }

    public void playerLogIn(PlayerEntity player) {
        if (!(player instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        new ServerPlayerLoginHandler().handle(serverPlayer);
    }

    public void onPlayerTick(boolean isTickStart, boolean isServerSide, PlayerEntity player) {
        if (!isTickStart || !isServerSide) {
            return;
        }
        if (!(player instanceof ServerPlayerEntity)) {
            return;
        }
        this.playerTickHandler.handle((ServerPlayerEntity)player);
    }

    public void serverStarting(MinecraftServer server) {
        for (ConfigChannel configChannel : ConfigChannelRegistry.INSTANCE) {
            configChannel.getServerConfigManager().setServer(server);
        }
    }

    public void onPlayerPermissionChange(PlayerEntity player) {
        if (!(player instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerData.get((ServerPlayerEntity)player).setShouldUpdateConfigPermissions(true);
    }
}

