/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketConsumerForge<P>
implements BiConsumer<P, Supplier<NetworkEvent.Context>> {
    private final BiConsumer<P, ServerPlayerEntity> serverHandler;
    private final Consumer<P> clientHandler;

    public PacketConsumerForge(BiConsumer<P, ServerPlayerEntity> serverHandler, Consumer<P> clientHandler) {
        this.serverHandler = serverHandler;
        this.clientHandler = clientHandler;
    }

    @Override
    public void accept(P msg, Supplier<NetworkEvent.Context> contextSuppplier) {
        NetworkEvent.Context context = contextSuppplier.get();
        if (msg == null) {
            context.setPacketHandled(true);
            return;
        }
        NetworkDirection networkDirection = context.getDirection();
        if (this.clientHandler != null && networkDirection == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> this.clientHandler.accept(msg));
        } else if (this.serverHandler != null && networkDirection == NetworkDirection.PLAY_TO_SERVER) {
            ServerPlayerEntity sender = context.getSender();
            context.enqueueWork(() -> this.serverHandler.accept(msg, sender));
        }
        context.setPacketHandled(true);
    }
}

