/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import xaero.lib.XaeroLib;
import xaero.lib.common.player.ServerPlayerData;
import xaero.lib.platform.Services;

public class ConfigChannelPacket {
    private final ResourceLocation channelId;

    public ConfigChannelPacket(ResourceLocation channelId) {
        this.channelId = channelId;
    }

    public void write(PacketBuffer buf) {
        CompoundNBT tag = new CompoundNBT();
        tag.putString("c", this.channelId.toString());
        buf.writeNbt(tag);
    }

    public static ConfigChannelPacket read(PacketBuffer buf) {
        try {
            CompoundNBT tag = buf.readNbt(new NBTSizeTracker(65536L));
            String channelIdString = tag.getString("c");
            return new ConfigChannelPacket(new ResourceLocation(channelIdString));
        }
        catch (Throwable t) {
            if (Services.PLATFORM.isDevelopmentEnvironment() || !Services.PLATFORM.isDedicatedServer()) {
                XaeroLib.LOGGER.error("packet error", t);
            }
            return null;
        }
    }

    public static final class ServerHandler
    implements BiConsumer<ConfigChannelPacket, ServerPlayerEntity> {
        @Override
        public void accept(ConfigChannelPacket packet, ServerPlayerEntity player) {
            block2: {
                try {
                    ServerPlayerData.get(player).getConfigSynchronizer().receiveChannelId(packet.channelId);
                }
                catch (Throwable t) {
                    ServerPlayerData.get(player).getConfigSynchronizer().receiveChannelId(null);
                    if (!Services.PLATFORM.isDevelopmentEnvironment()) break block2;
                    XaeroLib.LOGGER.error("packet error", t);
                }
            }
        }
    }

    public static final class ClientHandler
    implements Consumer<ConfigChannelPacket> {
        @Override
        public void accept(ConfigChannelPacket packet) {
            try {
                XaeroLib.INSTANCE.getClient().getConfigSynchronizer().receiveChannelId(packet.channelId);
            }
            catch (Throwable t) {
                XaeroLib.LOGGER.error("packet error", t);
            }
        }
    }
}

