/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config.profile;

import java.util.function.BiConsumer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.network.PacketBuffer;
import xaero.lib.XaeroLib;
import xaero.lib.common.player.ServerPlayerData;
import xaero.lib.platform.Services;

public final class ConfigProfileCreatePacket {
    private final String id;
    private final String name;
    private final String profileToCopy;

    public ConfigProfileCreatePacket(String id, String name, String profileToCopy) {
        this.id = id;
        this.name = name;
        this.profileToCopy = profileToCopy;
    }

    public void write(PacketBuffer buffer) {
        CompoundNBT tag = new CompoundNBT();
        tag.putString("i", this.id);
        tag.putString("n", this.name);
        tag.putString("c", this.profileToCopy);
        buffer.writeNbt(tag);
    }

    public static ConfigProfileCreatePacket read(PacketBuffer buffer) {
        try {
            CompoundNBT tag = buffer.readNbt(NBTSizeTracker.UNLIMITED);
            if (tag == null) {
                return null;
            }
            String id = tag.getString("i");
            String name = tag.getString("n");
            String profileToCopy = tag.getString("c");
            return new ConfigProfileCreatePacket(id, name, profileToCopy);
        }
        catch (Throwable t) {
            if (Services.PLATFORM.isDevelopmentEnvironment() || !Services.PLATFORM.isDedicatedServer()) {
                XaeroLib.LOGGER.error("packet error", t);
            }
            return null;
        }
    }

    public static final class ServerHandler
    implements BiConsumer<ConfigProfileCreatePacket, ServerPlayerEntity> {
        @Override
        public void accept(ConfigProfileCreatePacket packet, ServerPlayerEntity player) {
            block2: {
                try {
                    ServerPlayerData.get(player).getConfigSynchronizer().onCreateConfigProfilePacket(packet.id, packet.name, packet.profileToCopy);
                }
                catch (Throwable t) {
                    if (!Services.PLATFORM.isDevelopmentEnvironment()) break block2;
                    XaeroLib.LOGGER.error("packet error", t);
                }
            }
        }
    }
}

