/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config.profile;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.network.PacketBuffer;
import xaero.lib.XaeroLib;
import xaero.lib.common.player.ServerPlayerData;
import xaero.lib.platform.Services;

public class ConfigProfileDeletePacket {
    private final String profileId;

    public ConfigProfileDeletePacket(String profileId) {
        this.profileId = profileId;
    }

    public void write(PacketBuffer buffer) {
        CompoundNBT tag = new CompoundNBT();
        tag.putString("i", this.profileId);
        buffer.writeNbt(tag);
    }

    public static ConfigProfileDeletePacket read(PacketBuffer buffer) {
        try {
            CompoundNBT tag = buffer.readNbt(new NBTSizeTracker(65536L));
            if (tag == null) {
                return null;
            }
            String profileId = tag.getString("i");
            return new ConfigProfileDeletePacket(profileId);
        }
        catch (Throwable t) {
            if (Services.PLATFORM.isDevelopmentEnvironment()) {
                XaeroLib.LOGGER.error("packet error", t);
            }
            return null;
        }
    }

    public static final class ClientHandler
    implements Consumer<ConfigProfileDeletePacket> {
        @Override
        public void accept(ConfigProfileDeletePacket packet) {
            XaeroLib.INSTANCE.getClient().getConfigSynchronizer().onDeleteConfigProfilePacket(packet.profileId);
        }
    }

    public static final class ServerHandler
    implements BiConsumer<ConfigProfileDeletePacket, ServerPlayerEntity> {
        @Override
        public void accept(ConfigProfileDeletePacket packet, ServerPlayerEntity player) {
            ServerPlayerData.get(player).getConfigSynchronizer().onDeleteConfigProfilePacket(packet.profileId);
        }
    }
}

