/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config.profile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import xaero.lib.XaeroLib;
import xaero.lib.client.config.sync.ClientConfigSynchronizer;
import xaero.lib.common.player.ServerPlayerData;
import xaero.lib.platform.Services;

public final class ConfigProfileInfoPacket {
    private final List<Entry> entries;
    private final String defaultEnforcedProfileId;
    private final boolean reset;

    public ConfigProfileInfoPacket(List<Entry> entries, String defaultEnforcedProfileId, boolean reset) {
        this.entries = entries;
        this.defaultEnforcedProfileId = defaultEnforcedProfileId;
        this.reset = reset;
    }

    public ConfigProfileInfoPacket(String id, String name, String defaultEnforcedProfileId) {
        this(Lists.newArrayList((Object[])new Entry[]{new Entry(id, name)}), defaultEnforcedProfileId, false);
    }

    public ConfigProfileInfoPacket(List<Entry> entries) {
        this(entries, null, false);
    }

    public ConfigProfileInfoPacket(String id, String name) {
        this(Lists.newArrayList((Object[])new Entry[]{new Entry(id, name)}), null, false);
    }

    public void write(PacketBuffer buffer) {
        CompoundNBT tag = new CompoundNBT();
        ListNBT entriesTag = new ListNBT();
        for (Entry entry : this.entries) {
            CompoundNBT entryTag = new CompoundNBT();
            entryTag.putString("i", entry.id);
            entryTag.putString("n", entry.name);
            entriesTag.add((Object)entryTag);
        }
        tag.put("e", (INBT)entriesTag);
        if (this.defaultEnforcedProfileId != null) {
            tag.putString("d", this.defaultEnforcedProfileId);
        }
        tag.putBoolean("r", this.reset);
        buffer.writeNbt(tag);
    }

    public static ConfigProfileInfoPacket read(PacketBuffer buffer) {
        try {
            CompoundNBT tag = buffer.readAnySizeNbt();
            if (tag == null) {
                return null;
            }
            ArrayList<Entry> entries = new ArrayList<Entry>();
            ListNBT entriesTag = tag.getList("e", 10);
            for (INBT entryTag : entriesTag) {
                CompoundNBT entryTagCast = (CompoundNBT)entryTag;
                String id = entryTagCast.getString("i");
                String name = entryTagCast.getString("n");
                entries.add(new Entry(id, name));
            }
            String defaultEnforcedProfileId = tag.contains("d", 8) ? tag.getString("d") : null;
            boolean reset = tag.getBoolean("r");
            return new ConfigProfileInfoPacket(entries, defaultEnforcedProfileId, reset);
        }
        catch (Throwable t) {
            if (Services.PLATFORM.isDevelopmentEnvironment() || !Services.PLATFORM.isDedicatedServer()) {
                XaeroLib.LOGGER.error("packet error", t);
            }
            return null;
        }
    }

    public static final class ClientHandler
    implements Consumer<ConfigProfileInfoPacket> {
        @Override
        public void accept(ConfigProfileInfoPacket packet) {
            try {
                ClientConfigSynchronizer synchronizer = XaeroLib.INSTANCE.getClient().getConfigSynchronizer();
                synchronizer.onConfigProfileInfoPacket(packet.entries, packet.defaultEnforcedProfileId, packet.reset);
            }
            catch (Throwable t) {
                XaeroLib.LOGGER.error("packet error", t);
            }
        }
    }

    public static final class ServerHandler
    implements BiConsumer<ConfigProfileInfoPacket, ServerPlayerEntity> {
        @Override
        public void accept(ConfigProfileInfoPacket packet, ServerPlayerEntity player) {
            block2: {
                try {
                    ServerPlayerData.get(player).getConfigSynchronizer().onConfigProfileInfoPacket(packet.entries, packet.defaultEnforcedProfileId);
                }
                catch (Throwable t) {
                    if (!Services.PLATFORM.isDevelopmentEnvironment()) break block2;
                    XaeroLib.LOGGER.error("packet error", t);
                }
            }
        }
    }

    public static final class Entry {
        public final String id;
        public final String name;

        public Entry(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

