/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class TextSplitter {
    public static int splitTextIntoLines(List<ITextComponent> dest, int minWidth, int widthLimit, ITextProperties formattedText, StringBuilder plainTextBuilder) {
        SplitProgress progress = new SplitProgress();
        int spaceWidth = Minecraft.getInstance().font.width(" ");
        progress.resultWidth = minWidth;
        ITextProperties.IStyledTextAcceptor consumer = (style, text) -> {
            boolean endsWithSpace;
            boolean isEnd;
            boolean bl = isEnd = style == null;
            if (!isEnd && plainTextBuilder != null) {
                plainTextBuilder.append(text);
            }
            if (endsWithSpace = text.endsWith(" ")) {
                text = text + ".";
            }
            String[] parts = text.split(" ");
            for (int i = 0; i < parts.length; ++i) {
                boolean isNewLine;
                boolean canAddMultiword = isEnd || i < parts.length - 1;
                String part = isEnd || endsWithSpace && i == parts.length - 1 ? "" : parts[i];
                int partWidth = Minecraft.getInstance().font.width(part);
                if (!canAddMultiword) {
                    progress.buildMultiword(part, partWidth, style);
                    continue;
                }
                int wordWidth = partWidth + progress.multiwordWidth;
                int wordTakesWidth = wordWidth + (!progress.firstWord ? spaceWidth : 0);
                if (progress.lineWidth + wordTakesWidth <= widthLimit) {
                    progress.resultWidth = Math.max(progress.resultWidth, Math.min(widthLimit, progress.lineWidth + wordTakesWidth));
                }
                if (progress.firstWord && progress.lineWidth + wordTakesWidth > progress.resultWidth) {
                    progress.resultWidth = progress.lineWidth + wordTakesWidth;
                }
                boolean bl2 = isNewLine = progress.multiword == null && part.equals("\n");
                if (!isNewLine && progress.lineWidth + wordTakesWidth <= progress.resultWidth) {
                    progress.confirmWord(part, style, wordTakesWidth);
                    continue;
                }
                progress.confirmComponent();
                dest.add(progress.line);
                progress.nextLine();
                if (isNewLine) continue;
                --i;
            }
            return Optional.empty();
        };
        formattedText.visit(consumer, Style.EMPTY.withColor(TextFormatting.WHITE));
        if (progress.multiword != null) {
            consumer.accept(null, "end");
        } else if (progress.stringBuilder.length() > 0) {
            progress.confirmComponent();
        }
        if (progress.line != null) {
            dest.add(progress.line);
        }
        if (progress.resultWidth > minWidth) {
            --progress.resultWidth;
        }
        return progress.resultWidth;
    }

    public static class SplitProgress {
        int multiwordWidth;
        List<IFormattableTextComponent> multiword = null;
        boolean firstWord = true;
        ITextComponent line = null;
        StringBuilder stringBuilder = new StringBuilder();
        int lineWidth;
        Style lastStyle;
        int resultWidth;

        public void buildMultiword(String wordPart, int width, Style style) {
            IFormattableTextComponent wordPartComponent = new StringTextComponent(wordPart).withStyle(style);
            if (this.multiword == null) {
                this.multiword = new ArrayList<IFormattableTextComponent>();
            }
            this.multiword.add(wordPartComponent);
            this.multiwordWidth += width;
        }

        private void confirmWordPart(String part, Style style) {
            if (this.lastStyle != null && !Objects.equals(style, this.lastStyle)) {
                this.confirmComponent();
            }
            this.stringBuilder.append(part);
            this.lastStyle = style;
        }

        public void confirmWord(String lastPart, Style lastPartStyle, int width) {
            if (!this.firstWord) {
                this.stringBuilder.append(" ");
            }
            if (this.multiword != null) {
                for (ITextComponent iTextComponent : this.multiword) {
                    String text = iTextComponent.getContents();
                    Style style = iTextComponent.getStyle();
                    this.confirmWordPart(text, style);
                }
                this.multiword = null;
                this.multiwordWidth = 0;
            }
            this.confirmWordPart(lastPart, lastPartStyle);
            this.lineWidth += width;
            this.firstWord = false;
        }

        public void confirmComponent() {
            IFormattableTextComponent comp = new StringTextComponent(this.stringBuilder.toString()).withStyle(this.lastStyle == null ? Style.EMPTY : this.lastStyle);
            if (this.line != null) {
                if (this.stringBuilder.length() > 0) {
                    this.line.getSiblings().add(comp);
                }
            } else {
                this.line = comp;
            }
            this.stringBuilder.delete(0, this.stringBuilder.length());
        }

        public void nextLine() {
            this.firstWord = true;
            this.line = null;
            this.lastStyle = null;
            this.lineWidth = 0;
        }
    }
}

