/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class XaeroRenderType
extends RenderType {
    public static final RenderState.DepthTestState GREATER_DEPTH_TEST = new RenderState.DepthTestState(">", 516);
    public static final RenderState.TargetState KEEP_TARGET = new RenderState.TargetState("xaero_keep_target", () -> {}, () -> {});
    public static final RenderState.TransparencyState DEFAULT_TRANSLUCENT_TRANSPARENCY = new RenderState.TransparencyState("xaero_translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderState.TransparencyState LINES_TRANSPARENCY = new RenderState.TransparencyState("xaero_lines_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderState.TransparencyState PREMULTIPLIED_TRANSPARENCY = new RenderState.TransparencyState("xaero_premultiplied_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderState.TransparencyState DEST_TRANSPARENCY = new RenderState.TransparencyState("xaero_destination_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final float DEFAULT_POLYGON_OFFSET = 10.0f;
    public static final RenderState.LayerState DEFAULT_POLYGON_OFFSET_LAYERING = new RenderState.LayerState("xaero_polygon_offset_layering", () -> {
        RenderSystem.polygonOffset((float)0.0f, (float)10.0f);
        RenderSystem.enablePolygonOffset();
    }, () -> {
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
    });
    public static final RenderState.AlphaState ALMOST_ZERO_ALPHA = new RenderState.AlphaState(1.0E-4f);

    private XaeroRenderType(String name, VertexFormat vertexFormat, int drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static void resetDepthTest() {
        MultiPhaseBuilder.resetDepthTest();
    }

    public static void resetWriteMask() {
        MultiPhaseBuilder.resetWriteMask();
    }

    public static void resetTransparency() {
        MultiPhaseBuilder.resetTransparency();
    }

    public static RenderState.TransparencyState getTransparencyPhase(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        return new RenderState.TransparencyState("xaero_custom_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
    }

    public static class MultiPhaseBuilder
    extends RenderState {
        private RenderState.TextureState texture = RenderState.field_228523_o_;
        private RenderState.TransparencyState transparency = RenderState.field_228510_b_;
        private RenderState.DiffuseLightingState diffuseLighting = RenderState.field_228533_y_;
        private RenderState.ShadeModelState shadeModel = RenderState.field_228519_k_;
        private RenderState.AlphaState alpha = RenderState.field_228516_h_;
        private RenderState.DepthTestState depthTest = RenderState.field_228494_D_;
        private RenderState.CullState cull = RenderState.field_228534_z_;
        private RenderState.LightmapState lightmap = RenderState.field_228529_u_;
        private RenderState.OverlayState overlay = RenderState.field_228531_w_;
        private RenderState.FogState fog = RenderState.field_228502_L_;
        private RenderState.LayerState layering = RenderState.field_228498_H_;
        private RenderState.TargetState target = RenderState.field_228504_N_;
        private RenderState.TexturingState texturing = RenderState.field_228524_p_;
        private RenderState.WriteMaskState writeMaskState = RenderState.field_228495_E_;
        private RenderState.LineState lineWidth = RenderState.field_228506_P_;

        public MultiPhaseBuilder() {
            super("weird access error workaround", null, null);
        }

        public MultiPhaseBuilder texture(RenderState.TextureState texture) {
            this.texture = texture;
            return this;
        }

        public MultiPhaseBuilder transparency(RenderState.TransparencyState transparency) {
            this.transparency = transparency;
            return this;
        }

        public MultiPhaseBuilder diffuseLighting(RenderState.DiffuseLightingState diffuseLighting) {
            this.diffuseLighting = diffuseLighting;
            return this;
        }

        public MultiPhaseBuilder shadeModel(RenderState.ShadeModelState shadeModel) {
            this.shadeModel = shadeModel;
            return this;
        }

        public MultiPhaseBuilder alpha(RenderState.AlphaState alpha) {
            this.alpha = alpha;
            return this;
        }

        public MultiPhaseBuilder depthTest(RenderState.DepthTestState depthTest) {
            this.depthTest = depthTest;
            return this;
        }

        public MultiPhaseBuilder cull(RenderState.CullState cull) {
            this.cull = cull;
            return this;
        }

        public MultiPhaseBuilder lightmap(RenderState.LightmapState lightmap) {
            this.lightmap = lightmap;
            return this;
        }

        public MultiPhaseBuilder overlay(RenderState.OverlayState overlay) {
            this.overlay = overlay;
            return this;
        }

        public MultiPhaseBuilder fog(RenderState.FogState fog) {
            this.fog = fog;
            return this;
        }

        public MultiPhaseBuilder layering(RenderState.LayerState layering) {
            this.layering = layering;
            return this;
        }

        public MultiPhaseBuilder target(RenderState.TargetState target) {
            this.target = target;
            return this;
        }

        public MultiPhaseBuilder texturing(RenderState.TexturingState texturing) {
            this.texturing = texturing;
            return this;
        }

        public MultiPhaseBuilder writeMaskState(RenderState.WriteMaskState writeMaskState) {
            this.writeMaskState = writeMaskState;
            return this;
        }

        public MultiPhaseBuilder lineWidth(RenderState.LineState lineWidth) {
            this.lineWidth = lineWidth;
            return this;
        }

        public ImmutableList<RenderState> build() {
            return ImmutableList.of((Object)this.texture, (Object)this.transparency, (Object)this.diffuseLighting, (Object)this.shadeModel, (Object)this.alpha, (Object)this.depthTest, (Object)this.cull, (Object)this.lightmap, (Object)this.overlay, (Object)this.fog, (Object)this.layering, (Object)this.target, (Object[])new RenderState[]{this.texturing, this.writeMaskState, this.lineWidth});
        }

        public static void resetDepthTest() {
            RenderState.field_228493_C_.func_228547_a_();
            RenderState.field_228493_C_.func_228549_b_();
        }

        public static void resetWriteMask() {
            RenderState.field_228496_F_.func_228547_a_();
            RenderState.field_228496_F_.func_228549_b_();
            RenderState.field_228497_G_.func_228547_a_();
            RenderState.field_228497_G_.func_228549_b_();
        }

        public static void resetTransparency() {
            RenderState.field_228511_c_.func_228547_a_();
            RenderState.field_228511_c_.func_228549_b_();
        }
    }

    public static class MultiPhaseRenderType
    extends RenderType {
        public MultiPhaseRenderType(String name, VertexFormat vertexFormat, int drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, ImmutableList<RenderState> phases) {
            super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, () -> phases.forEach(RenderState::func_228547_a_), () -> phases.forEach(RenderState::func_228549_b_));
        }
    }
}

