/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.config;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.config.ConfigProfileDropdownContext;
import xaero.lib.client.gui.config.context.IEditConfigScreenContext;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.common.config.channel.ConfigChannel;
import xaero.lib.common.config.option.BuiltInProfiledConfigOptions;
import xaero.lib.common.config.util.ConfigUtils;

public final class ConfigProfileCreationScreen
extends ScreenBase {
    private static final ITextComponent PROFILE_TO_COPY_COMPONENT = new TranslationTextComponent("gui.xaero_config_profile_to_copy");
    private DropDownWidget profileToCopyDropdown;
    private TextFieldWidget editBox;
    private Button confirmButton;
    private String currentValue;
    private final IEditConfigScreenContext context;
    private final ConfigChannel channel;
    private final Runnable onConfirm;
    private ConfigProfileDropdownContext dropdownContext;
    private String selectedProfileToCopy;

    protected ConfigProfileCreationScreen(Screen parent, IEditConfigScreenContext context, ConfigChannel channel, Runnable onConfirm) {
        super(parent, parent, (ITextComponent)new TranslationTextComponent("gui.xaero_config_profile_creation_screen"));
        this.context = context;
        this.channel = channel;
        this.onConfirm = onConfirm;
        this.currentValue = "";
        this.selectedProfileToCopy = context.getSelectedProfileId(channel);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.dropdownContext = new ConfigProfileDropdownContext(this.context, this.channel, null, this.selectedProfileToCopy, false);
        this.profileToCopyDropdown = DropDownWidget.Builder.begin().setX(this.field_230708_k_ / 2 - 100).setY(this.field_230709_l_ / 7 + 15).setW(200).setCallback(this::onDropdownSelection).setOptions(this.dropdownContext.getOptions()).setSelected(this.dropdownContext.getInitialSelection()).setNarrationTitle(PROFILE_TO_COPY_COMPONENT).setContainer(this).build();
        this.func_230481_d_(this.profileToCopyDropdown);
        this.editBox = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 7 + 55, 200, 20, BuiltInProfiledConfigOptions.PROFILE_NAME.getDisplayName());
        this.editBox.func_146203_f(50);
        this.func_231035_a_((IGuiEventListener)this.editBox);
        this.editBox.func_146195_b(true);
        this.editBox.func_146180_a(this.currentValue);
        this.editBox.func_212954_a(this::onChange);
        this.func_230480_a_((Widget)this.editBox);
        this.confirmButton = new MySmallButton(200, this.field_230708_k_ / 2 - 155, this.field_230709_l_ / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_confirm"), b -> this.confirm());
        this.func_230480_a_((Widget)this.confirmButton);
        this.func_230480_a_((Widget)new MySmallButton(201, this.field_230708_k_ / 2 + 5, this.field_230709_l_ / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_cancel"), b -> this.goBack()));
        this.updateConfirmButton();
    }

    private boolean onDropdownSelection(DropDownWidget menu, int selected) {
        if (!this.context.getSyncStatus(this.channel)) {
            return false;
        }
        this.selectedProfileToCopy = this.dropdownContext.getProfiles()[selected].getId();
        return true;
    }

    private void onChange(String s) {
        this.currentValue = s;
        this.updateConfirmButton();
    }

    private boolean canConfirm() {
        return !this.editBox.func_146179_b().isEmpty() && BuiltInProfiledConfigOptions.PROFILE_NAME.isValidValue(this.editBox.func_146179_b());
    }

    private void updateConfirmButton() {
        this.confirmButton.field_230693_o_ = this.canConfirm();
    }

    public void confirm() {
        if (!this.canConfirm()) {
            return;
        }
        String autoId = ConfigUtils.getAutoProfileIdForName(this::profileExists, this.editBox.func_146179_b());
        this.createProfile(autoId, this.editBox.func_146179_b(), this.selectedProfileToCopy);
        this.context.setCurrentProfile(autoId, this.channel);
        this.onConfirm.run();
        this.goBack();
    }

    private boolean profileExists(String id) {
        return this.context.profileExists(id, this.channel);
    }

    private void createProfile(String id, String name, String profileToCopy) {
        this.context.createProfile(id, name, this.channel, profileToCopy);
    }

    public boolean func_231046_a_(int keyCode, int par2, int par3) {
        boolean result = super.func_231046_a_(keyCode, par2, par3);
        if (keyCode == 257 && this.canConfirm()) {
            this.confirmButton.func_230982_a_(0.0, 0.0);
            return true;
        }
        return result;
    }

    @Override
    public void func_230446_a_(MatrixStack poseStack) {
        super.func_230446_a_(poseStack);
        AbstractGui.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)PROFILE_TO_COPY_COMPONENT, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 7), (int)-1);
        AbstractGui.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 7 + 40), (int)-1);
    }

    @Override
    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partial) {
        this.func_230446_a_(poseStack);
        super.func_230430_a_(poseStack, mouseX, mouseY, partial);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.editBox != null) {
            this.editBox.func_146178_a();
        }
    }
}

