/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.config;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.config.EditConfigScreen;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.option.ConfigOption;

public class EditStringConfigOptionScreen<T>
extends ScreenBase {
    private TextFieldWidget editBox;
    private Button confirmButton;
    private final Config config;
    private final Config enforcedConfig;
    private final ConfigOption<T> configOption;
    private final boolean allowEmpty;
    private final boolean emptyMeansNull;
    private final Runnable postConfirmAction;
    private boolean valid;
    private String currentValue;
    private ITextComponent enforcedValueLabel;
    protected boolean shouldRenderEscapeScreen;

    public EditStringConfigOptionScreen(Screen parent, Screen escape, Config config, Config enforcedConfig, ConfigOption<T> configOption, boolean allowEmpty, boolean emptyMeansNull, Runnable postConfirmAction) {
        super(parent, escape, configOption.getDisplayName());
        this.config = config;
        this.enforcedConfig = enforcedConfig;
        this.configOption = configOption;
        this.allowEmpty = allowEmpty;
        this.emptyMeansNull = emptyMeansNull;
        this.postConfirmAction = postConfirmAction;
        T value = config.get(configOption);
        this.currentValue = value == null ? "" : configOption.getValueType().getIoCodec().encode(value, null, configOption);
        this.shouldRenderEscapeScreen = false;
        this.canSkipWorldRender = false;
        if (parent instanceof EditConfigScreen) {
            EditConfigScreen configScreen = (EditConfigScreen)parent;
            this.shouldRenderEscapeScreen = configScreen.shouldRenderEscapeScreen;
            this.canSkipWorldRender = configScreen.canSkipWorldRender();
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        Object enforcedValue = this.enforcedConfig == null ? null : (Object)this.enforcedConfig.get(this.configOption);
        this.enforcedValueLabel = enforcedValue == null ? null : new TranslationTextComponent("gui.xaero_config_value_enforced_string_edit", new Object[]{this.configOption.getValueType().getIoCodec().encode(enforcedValue, null, this.configOption)}).func_240699_a_(TextFormatting.YELLOW);
        this.editBox = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 7 + 29 - 2, 200, 20, this.configOption.getDisplayName());
        this.editBox.func_146203_f(this.configOption.getValueType().getIoCodec().getMaxStringLength());
        this.func_231035_a_((IGuiEventListener)this.editBox);
        this.editBox.func_146195_b(true);
        this.editBox.func_146180_a(this.currentValue);
        this.editBox.func_212954_a(this::onChange);
        this.func_230480_a_((Widget)this.editBox);
        this.confirmButton = new Button(this.field_230708_k_ / 2 - 105, this.field_230709_l_ / 7 + 29 + 48, 100, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_confirm"), b -> this.confirm());
        this.func_230480_a_((Widget)this.confirmButton);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 5, this.field_230709_l_ / 7 + 29 + 48, 100, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_cancel"), b -> this.goBack()));
        this.valid = true;
        this.updateConfirmButton();
    }

    private void onChange(String s) {
        this.currentValue = s;
        this.valid = true;
        if (this.editBox.func_146179_b().isEmpty()) {
            this.valid = this.allowEmpty;
            this.updateConfirmButton();
            return;
        }
        try {
            T value = this.configOption.getValueType().getIoCodec().decode(s, null, this.configOption);
            this.valid = this.configOption.isValidValue(value);
        }
        catch (Throwable t) {
            this.valid = false;
        }
        this.updateConfirmButton();
    }

    private boolean canConfirm() {
        return this.valid;
    }

    private void updateConfirmButton() {
        this.confirmButton.field_230693_o_ = this.canConfirm();
    }

    public void confirm() {
        Object value;
        if (!this.canConfirm()) {
            return;
        }
        Object t = value = this.editBox.func_146179_b().isEmpty() && this.emptyMeansNull ? null : (Object)this.configOption.getValueType().getIoCodec().decode(this.editBox.func_146179_b(), null, this.configOption);
        if (value != null && !this.configOption.isValidValue(value)) {
            return;
        }
        this.config.set(this.configOption, value);
        this.postConfirmAction.run();
        this.goBack();
    }

    public boolean func_231046_a_(int keyCode, int par2, int par3) {
        boolean result = super.func_231046_a_(keyCode, par2, par3);
        if (keyCode == 257 && this.canConfirm()) {
            this.confirmButton.func_230982_a_(0.0, 0.0);
            return true;
        }
        return result;
    }

    @Override
    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partial) {
        if (this.shouldRenderEscapeScreen) {
            this.renderEscapeScreen(poseStack, mouseX, mouseY, partial);
        }
        this.func_230446_a_(poseStack);
        super.func_230430_a_(poseStack, mouseX, mouseY, partial);
        if (this.enforcedValueLabel != null) {
            AbstractGui.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.enforcedValueLabel, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 7 + 29 - 22), (int)0xFFFFFF);
        }
        AbstractGui.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 7 + 29 - 42), (int)0xFFFFFF);
    }

    @Override
    public void func_231175_as__() {
        this.onExit(this.parent);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.editBox != null) {
            this.editBox.func_146178_a();
        }
    }
}

