/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.widget;

import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.util.text.ITextComponent;
import xaero.lib.common.config.util.ConfigUtils;

public class XaeroCycleButton<T>
extends AbstractButton {
    protected int currentIndex;
    protected final List<T> values;
    private T currentValue;
    protected final BiConsumer<XaeroCycleButton<T>, T> updatedValueConsumer;
    private final Function<T, ITextComponent> valueNamer;
    private final ITextComponent name;

    private XaeroCycleButton(int x, int y, int w, int h, BiConsumer<XaeroCycleButton<T>, T> updatedValueConsumer, ITextComponent name, Function<T, ITextComponent> valueNamer, int currentIndex, List<T> values, T currentValue) {
        super(x, y, w, h, name);
        this.updatedValueConsumer = updatedValueConsumer;
        this.name = name;
        this.valueNamer = valueNamer;
        this.currentIndex = currentIndex;
        this.values = values;
        this.currentValue = currentValue;
    }

    public void func_230930_b_() {
        this.iterate(Screen.func_231173_s_() ? -1 : 1);
    }

    private void iterate(int direction) {
        this.currentIndex += direction;
        this.putCurrentIndexInRange();
        this.currentValue = this.getListValue();
        this.updatedValueConsumer.accept(this, (XaeroCycleButton)((Object)this.currentValue));
        this.updateMessage();
    }

    private void putCurrentIndexInRange() {
        if (this.currentIndex >= this.values.size()) {
            this.currentIndex %= this.values.size();
            return;
        }
        if (this.currentIndex >= 0) {
            return;
        }
        this.currentIndex = this.values.size() + this.currentIndex % this.values.size();
        if (this.currentIndex == this.values.size()) {
            this.currentIndex = 0;
        }
    }

    public boolean func_231043_a_(double d, double e, double f) {
        return super.func_231043_a_(d, e, f);
    }

    public T getListValue() {
        if (this.currentIndex < 0 || this.currentIndex >= this.values.size()) {
            return null;
        }
        return this.values.get(this.currentIndex);
    }

    public T getValue() {
        return this.currentValue;
    }

    public void setValue(T value) {
        if (!Objects.equals(value, this.currentValue)) {
            this.currentIndex = 0;
            while (this.currentIndex < this.values.size() && !Objects.equals(this.values.get(this.currentIndex), value)) {
                ++this.currentIndex;
            }
        }
        this.currentValue = value;
        this.updateMessage();
    }

    public void updateMessage() {
        this.func_238482_a_(ConfigUtils.optionNameValue(this.name, this.valueNamer.apply(this.currentValue)));
    }

    public static <T> Builder<T> builder(Function<T, ITextComponent> valueNamer) {
        return Builder.begin(valueNamer);
    }

    public static final class Builder<T> {
        protected T initialValue;
        protected List<T> values;
        private final Function<T, ITextComponent> valueNamer;

        private Builder(Function<T, ITextComponent> valueNamer) {
            this.valueNamer = valueNamer;
        }

        private Builder<T> setDefault() {
            this.withInitialValue(null);
            this.withValues(null);
            return this;
        }

        public Builder<T> withInitialValue(T initialValue) {
            this.initialValue = initialValue;
            return this;
        }

        public Builder<T> withValues(List<T> values) {
            this.values = values;
            return this;
        }

        public XaeroCycleButton<T> create(int x, int y, int w, int h, ITextComponent name, BiConsumer<XaeroCycleButton<T>, T> updatedValueConsumer) {
            int currentIndex;
            if (this.values == null || this.valueNamer == null) {
                throw new IllegalStateException();
            }
            for (currentIndex = 0; currentIndex < this.values.size() && !Objects.equals(this.values.get(currentIndex), this.initialValue); ++currentIndex) {
            }
            XaeroCycleButton result = new XaeroCycleButton(x, y, w, h, updatedValueConsumer, name, this.valueNamer, currentIndex, this.values, this.initialValue);
            result.updateMessage();
            return result;
        }

        public static <T> Builder<T> begin(Function<T, ITextComponent> valueNamer) {
            return super.setDefault();
        }
    }
}

