/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import xaero.lib.common.packet.IPacketHandler;
import xaero.lib.common.packet.PacketConsumerForge;

public class PacketHandlerForge
implements IPacketHandler {
    public final SimpleChannel network;
    private final ResourceLocation channelId;

    private PacketHandlerForge(ResourceLocation channelId, String protocolVersion) {
        this.channelId = channelId;
        this.network = NetworkRegistry.newSimpleChannel((ResourceLocation)channelId, () -> protocolVersion, s -> true, s -> true);
    }

    @Override
    public ResourceLocation getChannelId() {
        return this.channelId;
    }

    @Override
    public <P> void register(int index, Class<P> type, BiConsumer<P, PacketBuffer> encoder, Function<PacketBuffer, P> decoder, BiConsumer<P, ServerPlayerEntity> serverHandler, Consumer<P> clientHandler) {
        PacketConsumerForge<P> consumer = new PacketConsumerForge<P>(serverHandler, clientHandler);
        if (serverHandler == null != (clientHandler == null)) {
            this.network.registerMessage(index, type, encoder, decoder, consumer, Optional.of(clientHandler == null ? NetworkDirection.PLAY_TO_SERVER : NetworkDirection.PLAY_TO_CLIENT));
        } else {
            this.network.registerMessage(index, type, encoder, decoder, consumer);
        }
    }

    public void sendToServer(Object packet) {
        this.network.send(PacketDistributor.SERVER.noArg(), packet);
    }

    public void sendToPlayer(ServerPlayerEntity player, Object packet) {
        this.network.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    public static final class Builder {
        private ResourceLocation channelId;
        private String protocolVersion;

        private Builder() {
        }

        public Builder setDefault() {
            this.setChannelId(null);
            this.setProtocolVersion(null);
            return this;
        }

        public Builder setChannelId(ResourceLocation channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder setProtocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public PacketHandlerForge build() {
            if (this.channelId == null || this.protocolVersion == null) {
                throw new IllegalStateException();
            }
            return new PacketHandlerForge(this.channelId, this.protocolVersion);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

