/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.option.value.sync.serialization.ConfigValueSyncCodec;

public abstract class AbstractConfigPacket<P extends AbstractConfigPacket<P>> {
    private final List<OptionEntry> entries;

    protected AbstractConfigPacket(List<OptionEntry> entries) {
        this.entries = entries;
    }

    public void write(PacketBuffer buffer) {
        CompoundNBT tag = new CompoundNBT();
        CompoundNBT optionsTag = new CompoundNBT();
        for (OptionEntry entry : this.entries) {
            optionsTag.func_218657_a(entry.optionId, entry.valueTag);
        }
        tag.func_218657_a("o", (INBT)optionsTag);
        this.writeExtra(tag);
        buffer.func_150786_a(tag);
    }

    public Iterable<OptionEntry> getEntries() {
        return this.entries;
    }

    protected abstract void writeExtra(CompoundNBT var1);

    public static List<OptionEntry> readOptions(CompoundNBT tag) {
        CompoundNBT optionsTag = tag.func_74775_l("o");
        ArrayList<OptionEntry> result = new ArrayList<OptionEntry>();
        for (String optionId : optionsTag.func_150296_c()) {
            INBT valueTag = optionsTag.func_74781_a(optionId);
            result.add(new OptionEntry(optionId, valueTag));
        }
        return result;
    }

    public static class OptionEntry {
        public static final INBT NULL_VALUE = new CompoundNBT();
        public final String optionId;
        public final INBT valueTag;

        public OptionEntry(String optionId, INBT valueTag) {
            this.optionId = optionId;
            this.valueTag = valueTag == null ? NULL_VALUE : valueTag;
        }

        public static <T> OptionEntry of(ConfigOption<T> option, T value) {
            ConfigValueSyncCodec<T, INBT> syncCodec = option.getValueType().getSyncCodec();
            INBT valueTag = value == null ? null : syncCodec.encode(value);
            return new OptionEntry(option.getId(), valueTag);
        }

        public static <T> OptionEntry of(Config config, ConfigOption<T> option) {
            return OptionEntry.of(option, config.get(option));
        }
    }
}

