/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import xaero.lib.XaeroLib;
import xaero.lib.common.packet.config.AbstractConfigPacket;

public final class ClientboundEnforcedConfigPacket
extends AbstractConfigPacket<ClientboundEnforcedConfigPacket> {
    private final boolean reset;

    public ClientboundEnforcedConfigPacket(List<AbstractConfigPacket.OptionEntry> entries, boolean reset) {
        super(entries);
        this.reset = reset;
    }

    @Override
    protected void writeExtra(CompoundNBT tag) {
        tag.func_74757_a("r", this.reset);
    }

    public static ClientboundEnforcedConfigPacket read(PacketBuffer buffer) {
        try {
            CompoundNBT tag = buffer.func_244273_m();
            if (tag == null) {
                return null;
            }
            List<AbstractConfigPacket.OptionEntry> entries = ClientboundEnforcedConfigPacket.readOptions(tag);
            boolean reset = tag.func_74767_n("r");
            return new ClientboundEnforcedConfigPacket(entries, reset);
        }
        catch (Throwable t) {
            XaeroLib.LOGGER.error("packet error", t);
            return null;
        }
    }

    public static final class ClientHandler
    implements Consumer<ClientboundEnforcedConfigPacket> {
        @Override
        public void accept(ClientboundEnforcedConfigPacket packet) {
            try {
                XaeroLib.INSTANCE.getClient().getConfigSynchronizer().onEnforcedConfigPacket(packet.reset, packet.getEntries());
            }
            catch (Throwable t) {
                XaeroLib.LOGGER.error("packet error", t);
            }
        }
    }
}

