/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config.profile;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.network.PacketBuffer;
import xaero.lib.XaeroLib;
import xaero.lib.common.packet.config.AbstractConfigPacket;
import xaero.lib.common.player.ServerPlayerData;
import xaero.lib.platform.Services;

public final class ConfigProfileEditPacket
extends AbstractConfigPacket<ConfigProfileEditPacket> {
    private final String profileId;

    public ConfigProfileEditPacket(String profileId, List<AbstractConfigPacket.OptionEntry> entries) {
        super(entries);
        this.profileId = profileId;
    }

    @Override
    protected void writeExtra(CompoundNBT tag) {
        tag.func_74778_a("i", this.profileId);
    }

    public static ConfigProfileEditPacket read(PacketBuffer buffer) {
        try {
            CompoundNBT tag = buffer.func_244272_a(new NBTSizeTracker(0x800000L));
            if (tag == null) {
                return null;
            }
            List<AbstractConfigPacket.OptionEntry> entries = ConfigProfileEditPacket.readOptions(tag);
            String profileId = tag.func_74779_i("i");
            return new ConfigProfileEditPacket(profileId, entries);
        }
        catch (Throwable t) {
            if (Services.PLATFORM.isDevelopmentEnvironment() || !Services.PLATFORM.isDedicatedServer()) {
                XaeroLib.LOGGER.error("packet error", t);
            }
            return null;
        }
    }

    public static final class ServerHandler
    implements BiConsumer<ConfigProfileEditPacket, ServerPlayerEntity> {
        @Override
        public void accept(ConfigProfileEditPacket message, ServerPlayerEntity player) {
            block2: {
                try {
                    ServerPlayerData.get(player).getConfigSynchronizer().onEditProfilePacket(message.profileId, message.getEntries());
                }
                catch (Throwable t) {
                    if (!Services.PLATFORM.isDevelopmentEnvironment()) break block2;
                    XaeroLib.LOGGER.error("packet error", t);
                }
            }
        }
    }

    public static final class ClientHandler
    implements Consumer<ConfigProfileEditPacket> {
        @Override
        public void accept(ConfigProfileEditPacket message) {
            try {
                XaeroLib.INSTANCE.getClient().getConfigSynchronizer().onEditProfilePacket(message.profileId, message.getEntries());
            }
            catch (Throwable t) {
                XaeroLib.LOGGER.error("packet error", t);
            }
        }
    }
}

