/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.util.graphics;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.renderer.GameRenderer;

public class GuiGraphicsUtils {
    public static void blit(PoseStack pose, int x, int y, float u, float v, int w, int h) {
        GuiGraphicsUtils.blit(pose, x, x + w, y, y + h, 0, w, h, u, v, 256, 256);
    }

    public static void blit(PoseStack pose, int x, int y, int z, float u, float v, int w, int h, int textureW, int textureH) {
        GuiGraphicsUtils.blit(pose, x, x + w, y, y + h, z, w, h, u, v, textureW, textureH);
    }

    static void blit(PoseStack pose, int left, int right, int top, int bottom, int z, int uw, int vh, float u, float v, int textureW, int textureH) {
        GuiGraphicsUtils.innerBlit(pose, left, right, top, bottom, z, (u + 0.0f) / (float)textureW, (u + (float)uw) / (float)textureW, (v + 0.0f) / (float)textureH, (v + (float)vh) / (float)textureH);
    }

    static void innerBlit(PoseStack pose, int left, int right, int top, int bottom, int z, float uLeft, float uRight, float vTop, float vBottom) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = pose.last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.vertex(matrix4f, (float)left, (float)top, (float)z).uv(uLeft, vTop).endVertex();
        bufferBuilder.vertex(matrix4f, (float)left, (float)bottom, (float)z).uv(uLeft, vBottom).endVertex();
        bufferBuilder.vertex(matrix4f, (float)right, (float)bottom, (float)z).uv(uRight, vBottom).endVertex();
        bufferBuilder.vertex(matrix4f, (float)right, (float)top, (float)z).uv(uRight, vTop).endVertex();
        BufferUploader.end((BufferBuilder)bufferBuilder);
    }
}

