/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.config;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import xaero.lib.XaeroLib;
import xaero.lib.client.config.option.ui.ConfigOptionScreenEntry;
import xaero.lib.client.gui.GuiSettings;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.TextSettingEntry;
import xaero.lib.client.gui.config.ConfigProfileCreationScreen;
import xaero.lib.client.gui.config.ConfigProfileDropdownContext;
import xaero.lib.client.gui.config.context.IEditConfigScreenContext;
import xaero.lib.client.gui.widget.MyTinyButton;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.common.config.channel.ConfigChannel;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.primary.option.BuiltInPrimaryCommonConfigOptions;
import xaero.lib.common.config.profile.ConfigProfile;
import xaero.lib.common.config.profile.IConfigProfileInfo;

public abstract class EditConfigScreen
extends GuiSettings {
    private static final Component NO_PERMISSION_0 = new TranslatableComponent("gui.xaero_no_config_edit_permission_0");
    private static final Component NO_PERMISSION_1 = new TranslatableComponent("gui.xaero_no_config_edit_permission_1");
    protected final IEditConfigScreenContext context;
    protected final ConfigChannel channel;
    private boolean shouldHandleChangesOnExit;
    private DropDownWidget dropdown;
    private boolean restoreDropdownFocus;
    private boolean syncStatusOnUpdate;
    private ConfigProfile profileOnUpdate;
    private ConfigProfileDropdownContext dropdownContext;
    private boolean hasPermissionToEdit;
    private ISettingEntry[] entriesBackup;
    private boolean shouldAskToConfirmOnExit;
    protected boolean shouldRenderEscapeScreen;

    public EditConfigScreen(Component title, Screen backScreen, Screen escScreen, IEditConfigScreenContext context, ConfigChannel channel) {
        super((Component)new TranslatableComponent(context.getScreenTitleFormat(), new Object[]{title}), backScreen, escScreen, !context.isAutoConfirm());
        this.context = context;
        this.channel = channel;
        this.shouldRenderEscapeScreen = true;
        this.canSkipWorldRender = true;
        if (!(backScreen instanceof EditConfigScreen)) {
            context.reset(channel);
            return;
        }
        EditConfigScreen backEditConfigScreen = (EditConfigScreen)backScreen;
        if (backEditConfigScreen.channel != channel || backEditConfigScreen.context != context) {
            context.reset(channel);
        }
    }

    private void updateEditedProfile() {
        this.hasPermissionToEdit = this.context.hasPermission(this.channel);
        if (!this.hasPermissionToEdit) {
            return;
        }
        this.syncStatusOnUpdate = this.context.getSyncStatus(this.channel);
        ConfigProfile editedProfile = this.context.getCurrentProfile(this.channel);
        if (editedProfile == null && this.syncStatusOnUpdate) {
            this.context.setCurrentProfile(this.context.getDefaultProfileId(this.channel), this.channel);
            this.syncStatusOnUpdate = this.context.getSyncStatus(this.channel);
            editedProfile = this.context.getCurrentProfile(this.channel);
        }
        if (this.profileOnUpdate == editedProfile) {
            return;
        }
        this.profileOnUpdate = editedProfile;
        this.onEditedProfileSwitch();
        this.shouldAskToConfirmOnExit = false;
        this.shouldHandleChangesOnExit = false;
    }

    protected void onEditedProfileSwitch() {
    }

    public boolean getSyncStatus() {
        return this.context.getSyncStatus(this.channel);
    }

    @Override
    public void m_7856_() {
        this.updateEditedProfile();
        if (!this.syncStatusOnUpdate || !this.hasPermissionToEdit) {
            if (this.entries != null) {
                this.entriesBackup = this.entries;
            }
            this.entries = null;
        } else if (this.entriesBackup != null) {
            this.entries = this.entriesBackup;
            this.entriesBackup = null;
        }
        super.m_7856_();
        this.dropdownContext = !this.hasPermissionToEdit ? null : new ConfigProfileDropdownContext(this.context, this.channel, this.profileOnUpdate, this.context.getSelectedProfileId(this.channel), true);
        String[] dropdownOptions = this.dropdownContext == null ? null : this.dropdownContext.getOptions();
        this.dropdown = null;
        if (dropdownOptions == null) {
            return;
        }
        int dropdownX = this.f_96543_ / 2 - 100;
        if (this.canSearch) {
            if (this.searchField != null) {
                this.searchField.m_94214_(this.f_96543_ / 2 + 5);
            }
            dropdownX = this.f_96543_ / 2 - 205;
        }
        this.dropdown = DropDownWidget.Builder.begin().setCallback(this::onDropdownSelection).setContainer(this).setX(dropdownX).setY(this.f_96544_ / 7 + 9).setW(200).setNarrationTitle(this.context.getDropdownNarration()).setSelected(this.dropdownContext.getInitialSelection()).setOptions(dropdownOptions).build();
        this.m_7787_(this.dropdown);
        int verticalOffset = this.getVerticalOffset();
        MyTinyButton deleteButton = new MyTinyButton(this.f_96543_ / 2 + 130, this.f_96544_ / 7 + 5 + verticalOffset - 48, (Component)new TranslatableComponent("gui.xaero_delete_profile"), this::onDeleteProfileButton);
        this.m_142416_((GuiEventListener)deleteButton);
        if (!this.context.isAutoDefaultProfile()) {
            MyTinyButton setDefaultButton = new MyTinyButton(this.f_96543_ / 2 - 205, this.f_96544_ / 7 + 5 + verticalOffset - 48, (Component)new TranslatableComponent("gui.xaero_set_default_profile"), this::onSetDefaultButton);
            this.m_142416_((GuiEventListener)setDefaultButton);
            setDefaultButton.f_93623_ = this.canSetDefault(this.profileOnUpdate);
        }
        String defaultProfileId = BuiltInPrimaryCommonConfigOptions.DEFAULT_ENFORCED_PROFILE.getDefaultValue();
        boolean bl = deleteButton.f_93623_ = this.profileOnUpdate != null && !this.profileOnUpdate.getId().equals(defaultProfileId);
        if (this.restoreDropdownFocus) {
            this.m_7522_((GuiEventListener)this.dropdown);
        }
    }

    private boolean onDropdownSelection(DropDownWidget menu, int selected) {
        if (!this.context.getSyncStatus(this.channel)) {
            return false;
        }
        this.handleChanges();
        if (this.shouldAskToConfirmOnExit) {
            this.askForConfirmation(() -> {
                this.f_96541_.m_91152_((Screen)this);
                this.onDropdownSelection(selected);
            });
            return false;
        }
        return this.onDropdownSelection(selected);
    }

    private boolean onDropdownSelection(int selected) {
        if (selected >= this.dropdownContext.getProfiles().length) {
            this.f_96541_.m_91152_((Screen)new ConfigProfileCreationScreen(this, this.context, this.channel, this::onCreatedProfile));
            return true;
        }
        IConfigProfileInfo newCurrent = this.dropdownContext.getProfiles()[selected];
        String newCurrentId = newCurrent.getId();
        this.context.setCurrentProfile(newCurrentId, this.channel);
        this.restoreDropdownFocus = true;
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        this.restoreDropdownFocus = false;
        return true;
    }

    private void onCreatedProfile() {
    }

    private boolean canSetDefault(ConfigProfile editedProfile) {
        return editedProfile != null && !editedProfile.getId().equals(this.context.getDefaultProfileId(this.channel));
    }

    private void onSetDefaultButton(Button button) {
        ConfigProfile editedProfile = this.context.getCurrentProfile(this.channel);
        if (editedProfile == null) {
            return;
        }
        if (!this.canSetDefault(editedProfile)) {
            return;
        }
        this.context.setDefaultProfileId(editedProfile.getId(), this.channel);
        button.f_93623_ = false;
    }

    private void onDeleteProfileButton(Button button) {
        ConfigProfile editedProfile = this.context.getCurrentProfile(this.channel);
        if (editedProfile == null) {
            return;
        }
        ConfigProfile profileToDelete = editedProfile;
        this.f_96541_.m_91152_((Screen)new ConfirmScreen(b -> {
            if (b) {
                this.onDeleteProfile(profileToDelete);
            }
            this.f_96541_.m_91152_((Screen)this);
        }, (Component)new TranslatableComponent("gui.xaero_delete_profile_0"), (Component)new TranslatableComponent("gui.xaero_delete_profile_1", new Object[]{profileToDelete.getName(), profileToDelete.getId()})));
    }

    private void onDeleteProfile(ConfigProfile profile) {
        if (profile == null) {
            return;
        }
        String defaultProfileId = BuiltInPrimaryCommonConfigOptions.DEFAULT_ENFORCED_PROFILE.getDefaultValue();
        if (profile.getId().equals(defaultProfileId)) {
            return;
        }
        this.context.deleteProfile(profile, this.channel);
        this.context.reset(this.channel);
        this.context.setCurrentProfile(defaultProfileId, this.channel);
        this.updateEditedProfile();
    }

    public void handleChangesOnExit() {
        this.shouldHandleChangesOnExit = true;
    }

    @Override
    public void onExit(Screen screen) {
        this.handleChanges();
        if (this.shouldAskToConfirmOnExit) {
            this.askForConfirmation(screen);
            return;
        }
        super.onExit(screen);
    }

    private void askForConfirmation(Screen destinationScreen) {
        this.askForConfirmation(() -> this.f_96541_.m_91152_(destinationScreen));
    }

    private void askForConfirmation(Runnable queuedAction) {
        this.shouldAskToConfirmOnExit = false;
        ConfigProfile editedProfile = this.context.getCurrentProfile(this.channel);
        int changeCount = editedProfile.getChangeCount();
        if (changeCount == 0) {
            this.context.reset(this.channel);
            queuedAction.run();
            return;
        }
        this.f_96541_.m_91152_((Screen)new ConfirmScreen(c -> {
            if (c) {
                this.confirmProfile();
            }
            this.context.reset(this.channel);
            queuedAction.run();
        }, (Component)new TranslatableComponent("gui.xaero_confirm_save_0"), (Component)new TranslatableComponent("gui.xaero_confirm_save_1", new Object[]{changeCount})));
    }

    @Override
    protected void confirm() {
        ConfigProfile editedProfile = this.context.getCurrentProfile(this.channel);
        if (editedProfile == null) {
            super.confirm();
            return;
        }
        this.handleChanges();
        this.confirmProfile();
        super.confirm();
    }

    private void confirmProfile() {
        this.shouldAskToConfirmOnExit = false;
        ConfigProfile editedProfile = this.context.getCurrentProfile(this.channel);
        this.context.confirmProfile(editedProfile, this.channel);
    }

    private void onWidgetChange() {
        if (!this.context.isAutoConfirm()) {
            this.shouldAskToConfirmOnExit = true;
            return;
        }
        this.confirmProfile();
    }

    protected void handleChanges() {
        if (!this.shouldHandleChangesOnExit) {
            return;
        }
        this.shouldHandleChangesOnExit = false;
        this.onWidgetChange();
        if (!this.context.isClientSide()) {
            return;
        }
        this.channel.getPrimaryClientConfigManagerIO().save();
    }

    public <T> ConfigOptionScreenEntry<T> optionEntry(ConfigOption<T> option) {
        return new ConfigOptionScreenEntry<T>(option, () -> this.context.getCurrentProfile(this.channel), () -> this.context.getEnforcedConfig(this.channel), () -> {
            if (Minecraft.m_91087_().f_91080_ instanceof EditConfigScreen) {
                ((EditConfigScreen)Minecraft.m_91087_().f_91080_).onWidgetChange();
            } else {
                this.onWidgetChange();
            }
        }, this.channel, this.context.isClientSide());
    }

    public <T> ConfigOptionScreenEntry<T> primaryOptionEntry(ConfigOption<T> option) {
        return new ConfigOptionScreenEntry<T>(option, () -> this.channel.getPrimaryClientConfigManager().getConfig(), () -> null, () -> this.channel.getPrimaryClientConfigManagerIO().save(), this.channel, this.context.isClientSide(), !this.context.isClientSide());
    }

    public <T> ConfigOptionScreenEntry<T> libPrimaryOptionEntry(ConfigOption<T> option) {
        return new ConfigOptionScreenEntry<T>(option, () -> XaeroLib.INSTANCE.getLibConfigChannel().getPrimaryClientConfigManager().getConfig(), () -> null, () -> XaeroLib.INSTANCE.getLibConfigChannel().getPrimaryClientConfigManagerIO().save(), XaeroLib.INSTANCE.getLibConfigChannel(), this.context.isClientSide(), !this.context.isClientSide());
    }

    public IEditConfigScreenContext getContext() {
        return this.context;
    }

    public ConfigProfile getProfileOnUpdate() {
        return this.profileOnUpdate;
    }

    @Override
    public void m_6305_(PoseStack poseStack, int par1, int par2, float par3) {
        if (this.hasPermissionToEdit && !this.syncStatusOnUpdate && this.context.getSyncStatus(this.channel)) {
            this.restoreDropdownFocus = this.dropdown != null && this.m_7222_() == this.dropdown;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            this.restoreDropdownFocus = false;
        }
        if (this.shouldRenderEscapeScreen) {
            this.renderEscapeScreen(poseStack, par1, par2, par3);
        }
        super.m_6305_(poseStack, par1, par2, par3);
        if (!this.hasPermissionToEdit) {
            GuiComponent.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)NO_PERMISSION_0, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 7 + 34), (int)-1);
            GuiComponent.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)NO_PERMISSION_1, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 7 + 54), (int)-1);
            return;
        }
        if (!this.syncStatusOnUpdate) {
            Component syncMessage = this.context.getSyncMessage();
            GuiComponent.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)syncMessage, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 7 + 34), (int)-1);
        }
    }

    public ISettingEntry createProfileIDEntry() {
        return new TextSettingEntry(() -> new TranslatableComponent("gui.xaero_config_profile_id", new Object[]{this.context.getSelectedProfileId(this.channel)}));
    }

    protected void resetProfileToDefaults() {
        ConfigProfile editedProfile = this.context.getCurrentProfile(this.channel);
        if (editedProfile == null) {
            return;
        }
        editedProfile.setDefaults(true);
        this.onWidgetChange();
    }

    protected void resetPrimaryToDefaults() {
        this.channel.getPrimaryClientConfigManager().getConfig().setDefaults(false);
    }

    @Override
    protected int getVerticalOffset() {
        return 24;
    }
}

