/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui;

import com.google.common.base.Objects;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import xaero.lib.XaeroLib;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.util.GuiUtils;
import xaero.lib.client.gui.widget.MyTinyButton;
import xaero.lib.client.gui.widget.online.WidgetScreen;
import xaero.lib.common.util.KeySortableByOther;

public abstract class GuiSettings
extends ScreenBase
implements WidgetScreen {
    protected int entriesPerPage = 12;
    protected ISettingEntry[] entries;
    protected String entryFilter = "";
    private boolean foundSomething;
    protected Component screenTitle;
    protected int page;
    protected int maxPage;
    private MyTinyButton nextButton;
    private MyTinyButton prevButton;
    protected EditBox searchField;
    protected boolean canSearch = true;
    private boolean shouldRefocusSearch;
    protected boolean confirmButton;

    public GuiSettings(Component title, Screen backScreen, Screen escScreen) {
        this(title, backScreen, escScreen, false);
    }

    public GuiSettings(Component title, Screen backScreen, Screen escScreen, boolean confirmButton) {
        super(backScreen, escScreen, title);
        this.confirmButton = confirmButton;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.screenTitle = this.f_96539_;
        if (this.confirmButton) {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 105, this.f_96544_ / 6 + 168, 100, 20, (Component)Component.m_237115_((String)"gui.xaero_confirm"), b -> this.confirm()));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ / 6 + 168, 100, 20, (Component)Component.m_237115_((String)"gui.xaero_back"), b -> this.goBack()));
        } else {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 6 + 168, 200, 20, (Component)Component.m_237110_((String)"gui.xaero_back", (Object[])new Object[0]), b -> this.goBack()));
        }
        int verticalOffset = this.getVerticalOffset();
        if (this.entries != null) {
            ArrayList<KeySortableByOther<ISettingEntry>> sortingList = new ArrayList<KeySortableByOther<ISettingEntry>>();
            String comparisonFilter = this.entryFilter.toLowerCase();
            for (int i = 0; i < this.entries.length; ++i) {
                int positionInEntryString;
                ISettingEntry entry = this.entries[i];
                String entrySearchString = entry.getStringForSearch().toLowerCase();
                if (entrySearchString == null || (positionInEntryString = entrySearchString.indexOf(comparisonFilter)) == -1) continue;
                KeySortableByOther<ISettingEntry> sortableEntry = new KeySortableByOther<ISettingEntry>(entry, Integer.valueOf(positionInEntryString));
                sortingList.add(sortableEntry);
            }
            ArrayList filteredEntries = sortingList.stream().sorted().map(KeySortableByOther::getKey).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            if (!filteredEntries.isEmpty()) {
                this.foundSomething = true;
                this.maxPage = (int)Math.ceil((double)filteredEntries.size() / (double)this.entriesPerPage) - 1;
                if (this.page > this.maxPage) {
                    this.page = this.maxPage;
                }
                int firstEntry = this.entriesPerPage * this.page;
                int entryCount = Math.min(filteredEntries.size() - firstEntry, this.entriesPerPage);
                for (int i = 0; i < entryCount; ++i) {
                    ISettingEntry entry = (ISettingEntry)filteredEntries.get(firstEntry + i);
                    AbstractWidget optionWidget = entry.createWidget(this.f_96543_ / 2 - 205 + i % 2 * 210, this.f_96544_ / 7 + 5 + verticalOffset + 24 * (i >> 1), 200);
                    this.m_142416_((GuiEventListener)optionWidget);
                }
            } else {
                this.foundSomething = false;
                this.page = 0;
                this.maxPage = 0;
            }
        }
        this.screenTitle = this.screenTitle.m_6879_().m_130946_(" (" + (this.page + 1) + "/" + (this.maxPage + 1) + ")");
        this.nextButton = new MyTinyButton(this.f_96543_ / 2 + 131, this.f_96544_ / 7 + 149 + verticalOffset, (Component)Component.m_237110_((String)"gui.xaero_next", (Object[])new Object[0]), b -> this.onNextButton());
        this.prevButton = new MyTinyButton(this.f_96543_ / 2 - 205, this.f_96544_ / 7 + 149 + verticalOffset, (Component)Component.m_237110_((String)"gui.xaero_previous", (Object[])new Object[0]), b -> this.onPrevButton());
        if (this.maxPage > 0) {
            this.m_142416_((GuiEventListener)this.nextButton);
            this.m_142416_((GuiEventListener)this.prevButton);
            this.nextButton.f_93623_ = this.page < this.maxPage;
            this.prevButton.f_93623_ = this.page > 0;
        }
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().initialize(this, this.f_96543_, this.f_96544_);
        boolean shouldFocusSearch = this.shouldRefocusSearch;
        this.shouldRefocusSearch = false;
        if (this.canSearch && this.entries != null) {
            int cursorPos = 0;
            if (shouldFocusSearch) {
                cursorPos = this.searchField.m_94207_();
            }
            this.searchField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 7 + 5 + verticalOffset - 24, 200, 20, (Component)Component.m_237115_((String)"gui.xaero_settings_search"));
            this.searchField.m_94144_(this.entryFilter);
            if (shouldFocusSearch) {
                this.m_7522_((GuiEventListener)this.searchField);
                this.searchField.m_94178_(true);
                this.searchField.m_94196_(cursorPos);
                this.searchField.m_94208_(cursorPos);
            }
            this.searchField.m_94151_(s -> {
                if (this.canSearch) {
                    this.updateSearch();
                }
            });
            this.m_7787_(this.searchField);
        } else {
            this.searchField = null;
        }
        this.f_96541_.f_91068_.m_90926_(true);
    }

    protected void confirm() {
        this.onExit(this.escape);
    }

    protected int getVerticalOffset() {
        return this.canSearch ? 24 : 0;
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.canSearch && this.searchField != null) {
            this.searchField.m_94120_();
        }
    }

    @Override
    protected void renderPreDropdown(PoseStack matrixStack, int mouseX, int mouseY, float partial) {
        super.renderPreDropdown(matrixStack, mouseX, mouseY, partial);
        if (this.searchField != null) {
            if (!this.foundSomething && this.entries != null) {
                GuiSettings.m_93208_((PoseStack)matrixStack, (Font)this.f_96541_.f_91062_, (String)I18n.m_118938_((String)"gui.xaero_settings_not_found", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 7 + 34), (int)0xFFFFFF);
            }
            if (!this.searchField.m_93696_() && this.searchField.m_94155_().isEmpty()) {
                GuiUtils.setFieldText(this.searchField, I18n.m_118938_((String)"gui.xaero_settings_search_placeholder", (Object[])new Object[0]), -11184811);
                this.searchField.m_94192_(0);
            }
            this.searchField.m_6305_(matrixStack, mouseX, mouseY, partial);
            if (!this.searchField.m_93696_()) {
                GuiUtils.setFieldText(this.searchField, this.entryFilter);
            }
        }
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int par1, int par2, float par3) {
        this.m_7333_(matrixStack);
        int verticalOffset = this.getVerticalOffset();
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().render(matrixStack, this, this.f_96543_, this.f_96544_, par1, par2, this.f_96541_.m_91268_().m_85449_());
        GuiSettings.m_93215_((PoseStack)matrixStack, (Font)this.f_96541_.f_91062_, (Component)this.screenTitle, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 7 + 29 - 42), (int)0xFFFFFF);
        super.m_6305_(matrixStack, par1, par2, par3);
        if (this.openDropdown == null) {
            this.renderTooltips(matrixStack, par1, par2, par3);
        }
    }

    @Override
    public void addButtonVisible(AbstractWidget button) {
        this.m_142416_((GuiEventListener)button);
    }

    @Override
    public <S extends Screen> S getScreen() {
        return (S)this;
    }

    @Override
    public void onExit(Screen screen) {
        super.onExit(screen);
    }

    public boolean m_7933_(int par1, int par2, int par3) {
        return super.m_7933_(par1, par2, par3) || this.m_7222_() instanceof EditBox && ((EditBox)this.m_7222_()).m_93696_();
    }

    public boolean m_5534_(char c, int i) {
        boolean result = super.m_5534_(c, i);
        return result;
    }

    @Override
    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().handleClick(this, this.f_96543_, this.f_96544_, (int)p_mouseClicked_1_, (int)p_mouseClicked_3_, this.f_96541_.m_91268_().m_85449_());
        return super.m_6375_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    protected void onNextButton() {
        ++this.page;
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    protected void onPrevButton() {
        --this.page;
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    public ISettingEntry[] getEntriesCopy() {
        if (this.entries == null) {
            return null;
        }
        ISettingEntry[] result = new ISettingEntry[this.entries.length];
        System.arraycopy(this.entries, 0, result, 0, this.entries.length);
        return result;
    }

    public void m_7522_(GuiEventListener guiEventListener) {
        GuiEventListener currentFocused = this.m_7222_();
        if (currentFocused != guiEventListener && currentFocused instanceof EditBox) {
            ((EditBox)currentFocused).m_94178_(false);
        }
        super.m_7522_(guiEventListener);
    }

    private void updateSearch() {
        String newValue;
        if (this.searchField.m_93696_() && !Objects.equal((Object)this.entryFilter, (Object)(newValue = this.searchField.m_94155_()))) {
            this.entryFilter = this.searchField.m_94155_();
            this.shouldRefocusSearch = true;
            this.page = 0;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
    }
}

