/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import xaero.lib.XaeroLib;
import xaero.lib.common.player.ServerPlayerData;
import xaero.lib.platform.Services;

public class ConfigChannelPacket {
    private final ResourceLocation channelId;

    public ConfigChannelPacket(ResourceLocation channelId) {
        this.channelId = channelId;
    }

    public void write(FriendlyByteBuf buf) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("c", this.channelId.toString());
        buf.m_130079_(tag);
    }

    public static ConfigChannelPacket read(FriendlyByteBuf buf) {
        try {
            CompoundTag tag = buf.m_130081_(new NbtAccounter(65536L));
            String channelIdString = tag.m_128461_("c");
            return new ConfigChannelPacket(new ResourceLocation(channelIdString));
        }
        catch (Throwable t) {
            if (Services.PLATFORM.isDevelopmentEnvironment() || !Services.PLATFORM.isDedicatedServer()) {
                XaeroLib.LOGGER.error("packet error", t);
            }
            return null;
        }
    }

    public static final class ServerHandler
    implements BiConsumer<ConfigChannelPacket, ServerPlayer> {
        @Override
        public void accept(ConfigChannelPacket packet, ServerPlayer player) {
            block2: {
                try {
                    ServerPlayerData.get(player).getConfigSynchronizer().receiveChannelId(packet.channelId);
                }
                catch (Throwable t) {
                    ServerPlayerData.get(player).getConfigSynchronizer().receiveChannelId(null);
                    if (!Services.PLATFORM.isDevelopmentEnvironment()) break block2;
                    XaeroLib.LOGGER.error("packet error", t);
                }
            }
        }
    }

    public static final class ClientHandler
    implements Consumer<ConfigChannelPacket> {
        @Override
        public void accept(ConfigChannelPacket packet) {
            try {
                XaeroLib.INSTANCE.getClient().getConfigSynchronizer().receiveChannelId(packet.channelId);
            }
            catch (Throwable t) {
                XaeroLib.LOGGER.error("packet error", t);
            }
        }
    }
}

