/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.lwjgl.glfw.GLFW;
import xaero.lib.XaeroLib;
import xaero.lib.client.gui.IScreenBase;
import xaero.lib.client.gui.widget.ITooltipHaver;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;

public class ScreenBase
extends Screen
implements IScreenBase {
    public Screen parent;
    public Screen escape;
    protected boolean canSkipWorldRender;
    protected DropDownWidget openDropdown;
    private List<DropDownWidget> dropdowns;
    protected boolean shouldRefresh;

    protected ScreenBase(Screen parent, Screen escape, Component titleIn) {
        super(titleIn);
        this.parent = parent;
        this.escape = escape;
        this.dropdowns = new ArrayList<DropDownWidget>();
    }

    public void onExit(Screen screen) {
        this.f_96541_.m_91152_(screen);
    }

    public void goBack() {
        this.onExit(this.parent);
    }

    public void m_7379_() {
        this.onExit(this.escape);
    }

    public void renderEscapeScreen(GuiGraphics guiGraphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        if (this.escape != null) {
            this.escape.m_88315_(guiGraphics, p_230430_2_, p_230430_3_, p_230430_4_);
            guiGraphics.m_280262_();
            GlStateManager._clear((int)256, (boolean)Minecraft.f_91002_);
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        this.handleRefresh();
        super.m_280273_(guiGraphics);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        this.handleRefresh();
        PoseStack poseStack = guiGraphics.m_280168_();
        super.m_88315_(guiGraphics, mouseX, mouseY, partial);
        this.renderPreDropdown(guiGraphics, mouseX, mouseY, partial);
        for (DropDownWidget dropdown : this.dropdowns) {
            dropdown.m_88315_(guiGraphics, mouseX, mouseY, partial);
        }
        if (this.openDropdown != null) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 2.0f);
            this.openDropdown.render(guiGraphics, mouseX, mouseY, this.f_96544_, false);
            poseStack.m_85849_();
        }
    }

    protected void renderPreDropdown(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
    }

    protected void m_7856_() {
        super.m_7856_();
        this.dropdowns.clear();
        this.openDropdown = null;
        if (this.escape != null) {
            this.escape.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.openDropdown != null) {
            if (!this.openDropdown.onDropDown((int)mouseX, (int)mouseY, this.f_96544_)) {
                this.openDropdown.setClosed(true);
                this.openDropdown = null;
            } else {
                this.openDropdown.m_6375_(mouseX, mouseY, button);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double wheel) {
        if (this.openDropdown != null) {
            if (this.openDropdown.onDropDown((int)mouseX, (int)mouseY, this.f_96544_)) {
                return this.openDropdown.m_6050_(mouseX, mouseY, wheel);
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, wheel);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.openDropdown != null && this.openDropdown.m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean shouldSkipWorldRender() {
        return this.canSkipWorldRender && this.escape instanceof IScreenBase && ((IScreenBase)this.escape).shouldSkipWorldRender();
    }

    protected boolean renderTooltips(GuiGraphics guiGraphics, int par1, int par2, float par3) {
        PoseStack matrixStack = guiGraphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 2.1);
        boolean result = XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().renderTooltips(guiGraphics, this, this.f_96543_, this.f_96544_, par1, par2, this.f_96541_.m_91268_().m_85449_());
        boolean mousePressed = GLFW.glfwGetMouseButton((long)this.f_96541_.m_91268_().m_85439_(), (int)0) == 1;
        for (GuiEventListener el : this.m_6702_()) {
            Tooltip tooltip;
            AbstractWidget b;
            if (!(el instanceof AbstractWidget) || !((b = (AbstractWidget)el) instanceof ITooltipHaver) || b instanceof AbstractSliderButton && mousePressed) continue;
            ITooltipHaver optionWidget = (ITooltipHaver)b;
            if (par1 < b.m_252754_() || par2 < b.m_252907_() || par1 >= b.m_252754_() + b.m_5711_() || par2 >= b.m_252907_() + b.m_93694_() || optionWidget.getXaero_tooltip() == null || (tooltip = optionWidget.getXaero_tooltip().get()) == null) continue;
            tooltip.drawBox(guiGraphics, par1, par2, this.f_96543_, this.f_96544_);
            result = true;
            break;
        }
        matrixStack.m_85849_();
        return result;
    }

    @Override
    public void onDropdownOpen(DropDownWidget menu) {
        if (this.openDropdown != null && this.openDropdown != menu) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = menu;
    }

    @Override
    public void onDropdownClosed(DropDownWidget menu) {
        if (menu != this.openDropdown && this.openDropdown != null) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = null;
    }

    protected <T extends GuiEventListener & NarratableEntry> T m_7787_(T guiEventListener) {
        if (guiEventListener instanceof DropDownWidget) {
            this.dropdowns.add((DropDownWidget)guiEventListener);
        }
        return (T)super.m_7787_(guiEventListener);
    }

    private void handleDropdownReplacement(AbstractWidget current, AbstractWidget replacement) {
        int dropdownIndex = this.dropdowns.indexOf(current);
        if (dropdownIndex != -1) {
            this.dropdowns.set(dropdownIndex, (DropDownWidget)replacement);
        }
        if (this.m_7222_() == current) {
            this.m_7522_((GuiEventListener)replacement);
        }
    }

    private void replaceWidget(AbstractWidget current, AbstractWidget replacement, boolean renderable) {
        int childIndex = this.m_6702_().indexOf(current);
        if (childIndex != -1) {
            super.m_169411_((GuiEventListener)current);
            if (renderable) {
                super.m_142416_((GuiEventListener)replacement);
            } else {
                super.m_7787_((GuiEventListener)replacement);
            }
            this.m_6702_().remove(replacement);
            this.m_6702_().add(childIndex, replacement);
        }
        this.handleDropdownReplacement(current, replacement);
    }

    public void replaceWidget(AbstractWidget current, AbstractWidget replacement) {
        this.replaceWidget(current, replacement, false);
    }

    public void replaceRenderableWidget(AbstractWidget current, AbstractWidget replacement) {
        this.replaceWidget(current, replacement, true);
    }

    protected void m_169411_(GuiEventListener current) {
        this.dropdowns.remove(current);
        super.m_169411_(current);
    }

    @Override
    public Screen getEscape() {
        return this.escape;
    }

    public static Screen tryToGetEscape(Screen screen) {
        if (screen instanceof IScreenBase) {
            IScreenBase screenBase = (IScreenBase)screen;
            return screenBase.getEscape();
        }
        return null;
    }

    protected void m_232761_() {
        super.m_232761_();
        this.handleRefresh();
    }

    public void refresh() {
        this.shouldRefresh = true;
    }

    protected final void handleRefresh() {
        if (!this.shouldRefresh) {
            return;
        }
        this.shouldRefresh = false;
        int focusedIndex = this.getIndex(this.m_7222_());
        this.m_232761_();
        this.restoreFocus(focusedIndex);
    }

    public void restoreFocus(int index) {
        if (index == -1) {
            return;
        }
        try {
            GuiEventListener child = (GuiEventListener)this.m_6702_().get(index);
            this.m_7522_(child);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public int getIndex(GuiEventListener child) {
        List children = this.m_6702_();
        for (int i = 0; i < children.size(); ++i) {
            if (children.get(i) != child) continue;
            return i;
        }
        return -1;
    }

    public boolean canSkipWorldRender() {
        return this.canSkipWorldRender;
    }
}

