/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;
import xaero.lib.client.graphics.shader.LibShaders;
import xaero.lib.client.graphics.shader.PositionTexAlphaTestShader;

public class ImmediateRenderUtil {
    public static void coloredRectangle(PoseStack matrices, float x1, float y1, float x2, float y2, int color) {
        ImmediateRenderUtil.coloredRectangle(matrices.m_85850_().m_252922_(), x1, y1, x2, y2, color);
    }

    public static void coloredRectangle(Matrix4f matrix, float x1, float y1, float x2, float y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tessellator.m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        vertexBuffer.m_252986_(matrix, x1, y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        vertexBuffer.m_252986_(matrix, x2, y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        vertexBuffer.m_252986_(matrix, x2, y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
        vertexBuffer.m_252986_(matrix, x1, y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
        tessellator.m_85914_();
    }

    public static void texturedRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        ImmediateRenderUtil.texturedRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, 0.0f, true);
    }

    public static void texturedRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha, boolean blend) {
        if (discardAlpha < 0.0f) {
            RenderSystem.setShader(blend ? () -> LibShaders.POSITION_TEX_NO_ALPHA_TEST : () -> LibShaders.POSITION_TEX_NO_ALPHA_TEST_NO_BLEND);
        } else {
            RenderSystem.setShader(blend ? () -> LibShaders.POSITION_TEX_ALPHA_TEST : () -> LibShaders.POSITION_TEX_ALPHA_TEST_NO_BLEND);
            ((PositionTexAlphaTestShader)RenderSystem.getShader()).setDiscardAlpha(discardAlpha);
        }
        ImmediateRenderUtil.texturedRectInternal(matrixStack, x, y, textureX, textureY, width, height, theight, factor);
    }

    private static void texturedRectInternal(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float textureH, float factor) {
        float f;
        float f1 = f = 1.0f / factor;
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tessellator.m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vertexBuffer.m_252986_(matrix, x + 0.0f, y + height, 0.0f).m_7421_((float)(textureX + 0) * f, (float)(textureY + 0) * f1).m_5752_();
        vertexBuffer.m_252986_(matrix, x + width, y + height, 0.0f).m_7421_(((float)textureX + width) * f, (float)(textureY + 0) * f1).m_5752_();
        vertexBuffer.m_252986_(matrix, x + width, y + 0.0f, 0.0f).m_7421_(((float)textureX + width) * f, ((float)textureY + textureH) * f1).m_5752_();
        vertexBuffer.m_252986_(matrix, x + 0.0f, y + 0.0f, 0.0f).m_7421_((float)(textureX + 0) * f, ((float)textureY + textureH) * f1).m_5752_();
        tessellator.m_85914_();
    }

    public static void drawOutlineLayer(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha) {
        LibShaders.POSITION_TEX_ICON_OUTLINE.setDiscardAlpha(discardAlpha);
        RenderSystem.setShader(() -> LibShaders.POSITION_TEX_ICON_OUTLINE);
        ImmediateRenderUtil.texturedRectInternal(matrixStack, x, y, textureX, textureY, width, height, theight, factor);
    }
}

