/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.config;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.config.ConfigProfileDropdownContext;
import xaero.lib.client.gui.config.context.IEditConfigScreenContext;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.common.config.channel.ConfigChannel;
import xaero.lib.common.config.option.BuiltInProfiledConfigOptions;
import xaero.lib.common.config.util.ConfigUtils;

public final class ConfigProfileCreationScreen
extends ScreenBase {
    private static final Component PROFILE_TO_COPY_COMPONENT = Component.m_237115_((String)"gui.xaero_config_profile_to_copy");
    private DropDownWidget profileToCopyDropdown;
    private EditBox editBox;
    private Button confirmButton;
    private String currentValue;
    private final IEditConfigScreenContext context;
    private final ConfigChannel channel;
    private final Runnable onConfirm;
    private ConfigProfileDropdownContext dropdownContext;
    private String selectedProfileToCopy;

    protected ConfigProfileCreationScreen(Screen parent, IEditConfigScreenContext context, ConfigChannel channel, Runnable onConfirm) {
        super(parent, parent, (Component)Component.m_237115_((String)"gui.xaero_config_profile_creation_screen"));
        this.context = context;
        this.channel = channel;
        this.onConfirm = onConfirm;
        this.currentValue = "";
        this.selectedProfileToCopy = context.getSelectedProfileId(channel);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.dropdownContext = new ConfigProfileDropdownContext(this.context, this.channel, null, this.selectedProfileToCopy, false);
        this.profileToCopyDropdown = DropDownWidget.Builder.begin().setX(this.f_96543_ / 2 - 100).setY(this.f_96544_ / 7 + 15).setW(200).setCallback(this::onDropdownSelection).setOptions(this.dropdownContext.getOptions()).setSelected(this.dropdownContext.getInitialSelection()).setNarrationTitle(PROFILE_TO_COPY_COMPONENT).setContainer(this).build();
        this.m_7787_(this.profileToCopyDropdown);
        this.editBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 7 + 55, 200, 20, BuiltInProfiledConfigOptions.PROFILE_NAME.getDisplayName());
        this.editBox.m_94199_(50);
        this.m_7522_((GuiEventListener)this.editBox);
        this.editBox.m_93692_(true);
        this.editBox.m_94144_(this.currentValue);
        this.editBox.m_94151_(this::onChange);
        this.m_142416_((GuiEventListener)this.editBox);
        this.confirmButton = new MySmallButton(200, this.f_96543_ / 2 - 155, this.f_96544_ / 6 + 168, (Component)Component.m_237115_((String)"gui.xaero_confirm"), b -> this.confirm());
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.m_142416_((GuiEventListener)new MySmallButton(201, this.f_96543_ / 2 + 5, this.f_96544_ / 6 + 168, (Component)Component.m_237115_((String)"gui.xaero_cancel"), b -> this.goBack()));
        this.updateConfirmButton();
    }

    private boolean onDropdownSelection(DropDownWidget menu, int selected) {
        if (!this.context.getSyncStatus(this.channel)) {
            return false;
        }
        this.selectedProfileToCopy = this.dropdownContext.getProfiles()[selected].getId();
        return true;
    }

    private void onChange(String s) {
        this.currentValue = s;
        this.updateConfirmButton();
    }

    private boolean canConfirm() {
        return !this.editBox.m_94155_().isEmpty() && BuiltInProfiledConfigOptions.PROFILE_NAME.isValidValue(this.editBox.m_94155_());
    }

    private void updateConfirmButton() {
        this.confirmButton.f_93623_ = this.canConfirm();
    }

    public void confirm() {
        if (!this.canConfirm()) {
            return;
        }
        String autoId = ConfigUtils.getAutoProfileIdForName(this::profileExists, this.editBox.m_94155_());
        this.createProfile(autoId, this.editBox.m_94155_(), this.selectedProfileToCopy);
        this.context.setCurrentProfile(autoId, this.channel);
        this.onConfirm.run();
        this.goBack();
    }

    private boolean profileExists(String id) {
        return this.context.profileExists(id, this.channel);
    }

    private void createProfile(String id, String name, String profileToCopy) {
        this.context.createProfile(id, name, this.channel, profileToCopy);
    }

    public boolean m_7933_(int keyCode, int par2, int par3) {
        boolean result = super.m_7933_(keyCode, par2, par3);
        if (keyCode == 257 && this.canConfirm()) {
            this.confirmButton.m_5716_(0.0, 0.0);
            return true;
        }
        return result;
    }

    @Override
    public void m_280273_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.m_280273_(guiGraphics, mouseX, mouseY, partial);
        guiGraphics.m_280653_(this.f_96547_, PROFILE_TO_COPY_COMPONENT, this.f_96543_ / 2, this.f_96544_ / 7, -1);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, this.f_96544_ / 7 + 40, -1);
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partial);
    }
}

