/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.config;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.config.EditConfigScreen;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.option.ConfigOption;

public class EditStringConfigOptionScreen<T>
extends ScreenBase {
    private EditBox editBox;
    private Button confirmButton;
    private final Config config;
    private final Config enforcedConfig;
    private final ConfigOption<T> configOption;
    private final boolean allowEmpty;
    private final boolean emptyMeansNull;
    private final Runnable postConfirmAction;
    private boolean valid;
    private String currentValue;
    private Component enforcedValueLabel;
    protected boolean shouldRenderEscapeScreen;

    public EditStringConfigOptionScreen(Screen parent, Screen escape, Config config, Config enforcedConfig, ConfigOption<T> configOption, boolean allowEmpty, boolean emptyMeansNull, Runnable postConfirmAction) {
        super(parent, escape, configOption.getDisplayName());
        this.config = config;
        this.enforcedConfig = enforcedConfig;
        this.configOption = configOption;
        this.allowEmpty = allowEmpty;
        this.emptyMeansNull = emptyMeansNull;
        this.postConfirmAction = postConfirmAction;
        T value = config.get(configOption);
        this.currentValue = value == null ? "" : configOption.getValueType().getIoCodec().encode(value, null, configOption);
        this.shouldRenderEscapeScreen = false;
        this.canSkipWorldRender = false;
        if (parent instanceof EditConfigScreen) {
            EditConfigScreen configScreen = (EditConfigScreen)parent;
            this.shouldRenderEscapeScreen = configScreen.shouldRenderEscapeScreen;
            this.canSkipWorldRender = configScreen.canSkipWorldRender();
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        Object enforcedValue = this.enforcedConfig == null ? null : (Object)this.enforcedConfig.get(this.configOption);
        this.enforcedValueLabel = enforcedValue == null ? null : Component.m_237110_((String)"gui.xaero_config_value_enforced_string_edit", (Object[])new Object[]{this.configOption.getValueType().getIoCodec().encode(enforcedValue, null, this.configOption)}).m_130940_(ChatFormatting.YELLOW);
        this.editBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 7 + 29 - 2, 200, 20, this.configOption.getDisplayName());
        this.editBox.m_94199_(this.configOption.getValueType().getIoCodec().getMaxStringLength());
        this.m_7522_((GuiEventListener)this.editBox);
        this.editBox.m_93692_(true);
        this.editBox.m_94144_(this.currentValue);
        this.editBox.m_94151_(this::onChange);
        this.m_142416_((GuiEventListener)this.editBox);
        this.confirmButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.xaero_confirm"), b -> this.confirm()).m_252987_(this.f_96543_ / 2 - 105, this.f_96544_ / 7 + 29 + 48, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.xaero_cancel"), b -> this.goBack()).m_252987_(this.f_96543_ / 2 + 5, this.f_96544_ / 7 + 29 + 48, 100, 20).m_253136_());
        this.valid = true;
        this.updateConfirmButton();
    }

    private void onChange(String s) {
        this.currentValue = s;
        this.valid = true;
        if (this.editBox.m_94155_().isEmpty()) {
            this.valid = this.allowEmpty;
            this.updateConfirmButton();
            return;
        }
        try {
            T value = this.configOption.getValueType().getIoCodec().decode(s, null, this.configOption);
            this.valid = this.configOption.isValidValue(value);
        }
        catch (Throwable t) {
            this.valid = false;
        }
        this.updateConfirmButton();
    }

    private boolean canConfirm() {
        return this.valid;
    }

    private void updateConfirmButton() {
        this.confirmButton.f_93623_ = this.canConfirm();
    }

    public void confirm() {
        Object value;
        if (!this.canConfirm()) {
            return;
        }
        Object t = value = this.editBox.m_94155_().isEmpty() && this.emptyMeansNull ? null : (Object)this.configOption.getValueType().getIoCodec().decode(this.editBox.m_94155_(), null, this.configOption);
        if (value != null && !this.configOption.isValidValue(value)) {
            return;
        }
        this.config.set(this.configOption, value);
        this.postConfirmAction.run();
        this.goBack();
    }

    public boolean m_7933_(int keyCode, int par2, int par3) {
        boolean result = super.m_7933_(keyCode, par2, par3);
        if (keyCode == 257 && this.canConfirm()) {
            this.confirmButton.m_5716_(0.0, 0.0);
            return true;
        }
        return result;
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        if (this.shouldRenderEscapeScreen) {
            this.renderEscapeScreen(guiGraphics, mouseX, mouseY, partial);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partial);
        if (this.enforcedValueLabel != null) {
            guiGraphics.m_280653_(this.f_96547_, this.enforcedValueLabel, this.f_96543_ / 2, this.f_96544_ / 7 + 29 - 22, 0xFFFFFF);
        }
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, this.f_96544_ / 7 + 29 - 42, 0xFFFFFF);
    }

    @Override
    public void m_7379_() {
        this.onExit(this.parent);
    }
}

