/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import xaero.lib.common.packet.PacketHandlerFull;
import xaero.lib.common.packet.type.PacketType;

public abstract class PacketReceiver<C> {
    private final PacketHandlerFull packetHandlerFull;

    public PacketReceiver(PacketHandlerFull packetHandlerFull) {
        this.packetHandlerFull = packetHandlerFull;
    }

    private PacketType<?> getPacketType(FriendlyByteBuf buf) {
        if (buf.readableBytes() <= 0) {
            return null;
        }
        byte index = buf.readByte();
        return this.packetHandlerFull.getPacketTypeByIndex(index);
    }

    protected void receive(ReentrantBlockableEventLoop<?> executor, FriendlyByteBuf buf, C context) {
        this.receive(executor, this.getPacketType(buf), buf, context);
    }

    private <T> void receive(ReentrantBlockableEventLoop<?> executor, PacketType<T> packetType, FriendlyByteBuf buf, C context) {
        if (packetType == null) {
            return;
        }
        if (!this.isCorrectSide(packetType)) {
            return;
        }
        T packet = packetType.getDecoder().apply(buf);
        if (executor.m_18695_()) {
            this.getTask(packetType, packet, context).run();
            return;
        }
        executor.execute(this.getTask(packetType, packet, context));
    }

    protected abstract <T> boolean isCorrectSide(PacketType<T> var1);

    protected abstract <T> Runnable getTask(PacketType<T> var1, T var2, C var3);
}

