/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.platform.services;

import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;
import xaero.lib.client.controls.util.IKeyMappingHelper;
import xaero.lib.client.controls.util.KeyMappingHelperForge;
import xaero.lib.client.graphics.util.IPlatformRenderHelper;
import xaero.lib.client.graphics.util.RenderDeviceHelperForge;
import xaero.lib.client.graphics.util.RenderHelperForge;
import xaero.lib.common.compat.ForgeModCompatibility;
import xaero.lib.common.compat.PlatformModCompatibility;
import xaero.lib.common.packet.IPacketHandler;
import xaero.lib.common.packet.PacketHandlerForge;
import xaero.lib.common.reflection.util.ObfuscatedReflectionForge;
import xaero.lib.platform.services.IPlatformHelper;

public class PlatformHelperForge
implements IPlatformHelper {
    private final KeyMappingHelperForge keyMappingHelper = new KeyMappingHelperForge();
    private final RenderHelperForge renderHelper = new RenderHelperForge();
    private final ObfuscatedReflectionForge obfuscatedReflection = new ObfuscatedReflectionForge();
    private final RenderDeviceHelperForge renderDeviceHelper = new RenderDeviceHelperForge();

    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean checkModForMixin(String modId) {
        return LoadingModList.get().getModFileById(modId) != null;
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public boolean isDedicatedServer() {
        return FMLLoader.getDist() == Dist.DEDICATED_SERVER;
    }

    @Override
    public IKeyMappingHelper getKeyMappingHelper() {
        return this.keyMappingHelper;
    }

    @Override
    public IPlatformRenderHelper getPlatformRenderHelper() {
        return this.renderHelper;
    }

    @Override
    public RenderDeviceHelperForge getRenderDeviceHelper() {
        return this.renderDeviceHelper;
    }

    @Override
    public ObfuscatedReflectionForge getObfuscatedReflection() {
        return this.obfuscatedReflection;
    }

    @Override
    public IPacketHandler createPacketHandler(ResourceLocation channelId, int protocolVersion, String platformVersionString) {
        return PacketHandlerForge.Builder.begin().setChannelId(channelId).setProtocolVersion(protocolVersion).build();
    }

    @Override
    public PlatformModCompatibility createPlatformModCompatibility() {
        return new ForgeModCompatibility();
    }

    @Override
    public Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }
}

