/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import xaero.lib.XaeroLib;
import xaero.lib.client.event.ClientEventsForge;
import xaero.lib.common.event.CommonEventsForge;
import xaero.lib.common.permission.system.ForgePermissionSystem;
import xaero.lib.common.permission.system.PermissionSystemRegistry;

@Mod(value="xaerolib")
public class XaeroLibForge
extends XaeroLib {
    public XaeroLibForge(FMLJavaModLoadingContext context) {
        this.registerEvents(context);
    }

    private void registerEvents(FMLJavaModLoadingContext context) {
        FMLCommonSetupEvent.getBus((BusGroup)context.getModBusGroup()).addListener(this::loadCommonForge);
        FMLClientSetupEvent.getBus((BusGroup)context.getModBusGroup()).addListener(this::loadClientForge);
        FMLDedicatedServerSetupEvent.getBus((BusGroup)context.getModBusGroup()).addListener(this::loadServerForge);
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventsForge());
        if (FMLLoader.getDist() == Dist.CLIENT) {
            this.registerClientEvents(context);
        }
    }

    private void registerClientEvents(FMLJavaModLoadingContext context) {
        ClientEventsForge clientEvents = new ClientEventsForge();
        MinecraftForge.EVENT_BUS.register((Object)clientEvents);
    }

    private void loadCommonForge(FMLCommonSetupEvent event) {
        this.loadCommon();
    }

    private void loadClientForge(FMLClientSetupEvent event) {
        this.loadClient();
        ModContainer modContainer = ModList.get().getModContainerById("xaerolib").orElse(null);
        ModLoadingStage.SIDED_SETUP.getDeferredWorkQueue().enqueueWork(modContainer, this::deferredTaskClient);
    }

    private void loadServerForge(FMLDedicatedServerSetupEvent event) {
        this.loadServer();
        ModContainer modContainer = ModList.get().getModContainerById("xaerolib").orElse(null);
        ModLoadingStage.SIDED_SETUP.getDeferredWorkQueue().enqueueWork(modContainer, this::deferredTaskServer);
    }

    @Override
    public void loadCommonLater() {
        PermissionSystemRegistry.INSTANCE.register(new ForgePermissionSystem());
        super.loadCommonLater();
    }

    private void deferredTaskClient() {
        this.loadCommonLater();
        this.loadClientLater();
    }

    private void deferredTaskServer() {
        this.loadCommonLater();
        this.loadServerLater();
    }
}

