/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client;

import xaero.lib.XaeroLib;
import xaero.lib.client.config.sync.ClientConfigSynchronizer;
import xaero.lib.client.graphics.XaeroBufferProvider;
import xaero.lib.client.gui.widget.online.WidgetLoadingHandler;
import xaero.lib.client.gui.widget.online.WidgetScreenHandler;
import xaero.lib.patreon.Patreon;

public class XaeroLibClient {
    private Throwable firstStageError;
    private ClientConfigSynchronizer configSynchronizer;
    private WidgetScreenHandler widgetScreenHandler;
    private WidgetLoadingHandler widgetLoader;
    private XaeroBufferProvider bufferProvider;

    public void load() {
        try {
            XaeroLib.LOGGER.info("Loading XaeroLib client 1/2!");
            this.bufferProvider = XaeroBufferProvider.Builder.begin().build();
            this.configSynchronizer = ClientConfigSynchronizer.Builder.begin().build();
            this.widgetScreenHandler = new WidgetScreenHandler();
            this.widgetLoader = new WidgetLoadingHandler(this.widgetScreenHandler);
            Patreon.checkPatreon();
        }
        catch (Throwable t) {
            this.firstStageError = t;
        }
    }

    public void loadLater() {
        if (this.firstStageError != null) {
            throw new RuntimeException(this.firstStageError);
        }
        XaeroLib.LOGGER.info("Loading XaeroLib client 2/2!");
    }

    public ClientConfigSynchronizer getConfigSynchronizer() {
        return this.configSynchronizer;
    }

    public WidgetScreenHandler getWidgetScreenHandler() {
        return this.widgetScreenHandler;
    }

    public WidgetLoadingHandler getWidgetLoader() {
        return this.widgetLoader;
    }

    public XaeroBufferProvider getBufferProvider() {
        return this.bufferProvider;
    }
}

