/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.controls.util;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import org.lwjgl.glfw.GLFW;
import xaero.lib.client.controls.util.IKeyMappingHelper;
import xaero.lib.platform.Services;

public class KeyMappingUtils {
    public static boolean inputMatches(InputConstants.Type type, int code, KeyMapping kb, int keyConflictContext) {
        IKeyMappingHelper keyBindingHelper = Services.PLATFORM.getKeyMappingHelper();
        return kb != null && code != -1 && keyBindingHelper.getBoundKeyOf(kb).getType() == type && keyBindingHelper.getBoundKeyOf(kb).getValue() == code && keyBindingHelper.modifiersAreActive(kb, keyConflictContext);
    }

    public static void setKeyState(KeyMapping keyMapping, boolean pressed) {
        KeyMapping.set((InputConstants.Key)Services.PLATFORM.getKeyMappingHelper().getBoundKeyOf(keyMapping), (boolean)pressed);
    }

    public static boolean isPhysicallyDown(KeyMapping keyMapping) {
        IKeyMappingHelper keyBindingHelper = Services.PLATFORM.getKeyMappingHelper();
        if (keyBindingHelper.getBoundKeyOf(keyMapping).getValue() == -1) {
            return false;
        }
        if (keyBindingHelper.getBoundKeyOf(keyMapping).getType() == InputConstants.Type.MOUSE) {
            return GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().handle(), (int)keyBindingHelper.getBoundKeyOf(keyMapping).getValue()) == 1;
        }
        if (keyBindingHelper.getBoundKeyOf(keyMapping).getType() == InputConstants.Type.KEYSYM) {
            return InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)keyBindingHelper.getBoundKeyOf(keyMapping).getValue());
        }
        return false;
    }

    public static String getKeyName(KeyMapping kb) {
        if (kb == null || Services.PLATFORM.getKeyMappingHelper().getBoundKeyOf(kb).getValue() == -1) {
            return "(unset)";
        }
        return kb.getTranslatedKeyMessage().getString().toUpperCase();
    }
}

