/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics.util;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.Identifier;

public class TextureUtils {
    public static GpuTextureView getView(Identifier identifier) {
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(identifier);
        return texture == null ? null : texture.getTextureView();
    }

    public static GpuSampler getSampler(Identifier identifier) {
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(identifier);
        return texture == null ? null : texture.getSampler();
    }

    public static void clearRenderTarget(RenderTarget renderTarget, int color, float depth) {
        RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(renderTarget.getColorTexture(), color, renderTarget.getDepthTexture(), (double)depth);
    }

    public static void clearRenderTarget(RenderTarget renderTarget, int color) {
        RenderSystem.getDevice().createCommandEncoder().clearColorTexture(renderTarget.getColorTexture(), color);
    }

    public static void clearRenderTargetDepth(RenderTarget renderTarget, float depth) {
        RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(renderTarget.getDepthTexture(), (double)depth);
    }

    public static IntBuffer allocateIntBuffer(int capacity, ByteOrder order) {
        return ByteBuffer.allocateDirect(capacity * 4).order(order).asIntBuffer();
    }

    public static ByteBuffer allocateByteBuffer(int capacity, ByteOrder order) {
        return ByteBuffer.allocateDirect(capacity).order(order);
    }
}

