/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class PacketConsumerForge<P>
implements BiConsumer<P, CustomPayloadEvent.Context> {
    private final BiConsumer<P, ServerPlayer> serverHandler;
    private final Consumer<P> clientHandler;

    public PacketConsumerForge(BiConsumer<P, ServerPlayer> serverHandler, Consumer<P> clientHandler) {
        this.serverHandler = serverHandler;
        this.clientHandler = clientHandler;
    }

    @Override
    public void accept(P msg, CustomPayloadEvent.Context context) {
        if (msg == null) {
            context.setPacketHandled(true);
            return;
        }
        if (this.clientHandler != null && context.isClientSide()) {
            context.enqueueWork(() -> this.clientHandler.accept(msg));
        } else if (this.serverHandler != null && context.isServerSide()) {
            ServerPlayer sender = context.getSender();
            context.enqueueWork(() -> this.serverHandler.accept(msg, sender));
        }
        context.setPacketHandled(true);
    }
}

