/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import xaero.lib.common.packet.IPacketHandler;
import xaero.lib.common.packet.PacketConsumerForge;

public class PacketHandlerForge
implements IPacketHandler {
    public final SimpleChannel network;
    private final ResourceLocation channelId;

    private PacketHandlerForge(ResourceLocation channelId, int protocolVersion) {
        this.channelId = channelId;
        this.network = ChannelBuilder.named((ResourceLocation)channelId).networkProtocolVersion(protocolVersion).optional().simpleChannel();
    }

    @Override
    public ResourceLocation getChannelId() {
        return this.channelId;
    }

    @Override
    public <P> void register(int index, Class<P> type, BiConsumer<P, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, P> decoder, BiConsumer<P, ServerPlayer> serverHandler, Consumer<P> clientHandler) {
        PacketConsumerForge<P> consumer = new PacketConsumerForge<P>(serverHandler, clientHandler);
        if (serverHandler == null != (clientHandler == null)) {
            this.network.messageBuilder(type, index, clientHandler != null ? NetworkDirection.PLAY_TO_CLIENT : NetworkDirection.PLAY_TO_SERVER).consumerNetworkThread(consumer).decoder(decoder::apply).encoder(encoder::accept).add();
        } else {
            this.network.messageBuilder(type, index).consumerNetworkThread(consumer).decoder(decoder).encoder(encoder).add();
        }
    }

    public void sendToServer(Object packet) {
        this.network.send(packet, PacketDistributor.SERVER.noArg());
    }

    public void sendToPlayer(ServerPlayer player, Object packet) {
        this.network.send(packet, PacketDistributor.PLAYER.with((Object)player));
    }

    public static final class Builder {
        private ResourceLocation channelId;
        private int protocolVersion;

        private Builder() {
        }

        public Builder setDefault() {
            this.setChannelId(null);
            this.setProtocolVersion(-1);
            return this;
        }

        public Builder setChannelId(ResourceLocation channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder setProtocolVersion(int protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public PacketHandlerForge build() {
            if (this.channelId == null || this.protocolVersion == -1) {
                throw new IllegalStateException();
            }
            return new PacketHandlerForge(this.channelId, this.protocolVersion);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

