/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics.util;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderPipelines;
import org.joml.Matrix4f;
import xaero.lib.client.graphics.XaeroRenderType;
import xaero.lib.client.graphics.shader.CustomUniforms;
import xaero.lib.client.graphics.shader.PositionTexAlphaTestShaderHelper;
import xaero.lib.platform.Services;

public class ImmediateRenderUtil {
    public static void coloredRectangle(PoseStack matrices, float x1, float y1, float x2, float y2, int color) {
        ImmediateRenderUtil.coloredRectangle(matrices.last().pose(), x1, y1, x2, y2, color);
    }

    public static void coloredRectangle(Matrix4f matrix, float x1, float y1, float x2, float y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        vertexBuffer.addVertex(matrix, x1, y2, 0.0f).setColor(r, g, b, a);
        vertexBuffer.addVertex(matrix, x2, y2, 0.0f).setColor(r, g, b, a);
        vertexBuffer.addVertex(matrix, x2, y1, 0.0f).setColor(r, g, b, a);
        vertexBuffer.addVertex(matrix, x1, y1, 0.0f).setColor(r, g, b, a);
        ImmediateRenderUtil.drawImmediateMeshData(vertexBuffer.build(), RenderPipelines.GUI);
    }

    public static void negativeColorRectangle(PoseStack matrices, float x1, float y1, float x2, float y2) {
        Matrix4f matrix = matrices.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        vertexBuffer.addVertex(matrix, x1, y2, 0.0f);
        vertexBuffer.addVertex(matrix, x2, y2, 0.0f);
        vertexBuffer.addVertex(matrix, x2, y1, 0.0f);
        vertexBuffer.addVertex(matrix, x1, y1, 0.0f);
        ImmediateRenderUtil.drawImmediateMeshData(vertexBuffer.build(), XaeroRenderType.RP_NEGATIVE_COLOR);
    }

    public static void texturedRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        ImmediateRenderUtil.texturedRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, 0.0f);
    }

    public static void texturedRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha) {
        RenderPipeline pipeline;
        if (discardAlpha < 0.0f) {
            pipeline = XaeroRenderType.RP_POSITION_TEX_NO_ALPHA;
        } else {
            pipeline = XaeroRenderType.RP_POSITION_TEX_ALPHA;
            PositionTexAlphaTestShaderHelper.setDiscardAlpha(discardAlpha);
        }
        ImmediateRenderUtil.texturedRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, pipeline);
    }

    public static void texturedRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float textureH, float factor, RenderPipeline renderPipeline) {
        float f;
        float f1 = f = 1.0f / factor;
        Matrix4f matrix = matrixStack.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, renderPipeline.getVertexFormat());
        vertexBuffer.addVertex(matrix, x + 0.0f, y + height, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv((float)(textureX + 0) * f, (float)(textureY + 0) * f1);
        vertexBuffer.addVertex(matrix, x + width, y + height, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(((float)textureX + width) * f, (float)(textureY + 0) * f1);
        vertexBuffer.addVertex(matrix, x + width, y + 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(((float)textureX + width) * f, ((float)textureY + textureH) * f1);
        vertexBuffer.addVertex(matrix, x + 0.0f, y + 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv((float)(textureX + 0) * f, ((float)textureY + textureH) * f1);
        ImmediateRenderUtil.drawImmediateMeshData(vertexBuffer.build(), renderPipeline);
    }

    public static void drawOutlineLayer(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha) {
        RenderPipeline pipeline = XaeroRenderType.RP_ICON_OUTLINE;
        PositionTexAlphaTestShaderHelper.setDiscardAlpha(discardAlpha);
        ImmediateRenderUtil.texturedRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, pipeline);
    }

    public static void drawImmediateMeshData(MeshData meshData, RenderPipeline renderPipeline) {
        ImmediateRenderUtil.drawImmediateMeshData(meshData, renderPipeline, Minecraft.getInstance().getMainRenderTarget());
    }

    public static void drawImmediateMeshData(MeshData meshData, RenderPipeline renderPipeline, RenderTarget target) {
        VertexFormat.IndexType gpuIndexType;
        GpuBuffer gpuIndexBuffer;
        ByteBuffer indexBuffer = meshData.indexBuffer();
        if (indexBuffer == null) {
            RenderSystem.AutoStorageIndexBuffer sequentialBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)meshData.drawState().mode());
            gpuIndexBuffer = sequentialBuffer.getBuffer(meshData.drawState().indexCount());
            gpuIndexType = sequentialBuffer.type();
        } else {
            gpuIndexBuffer = renderPipeline.getVertexFormat().uploadImmediateIndexBuffer(indexBuffer);
            gpuIndexType = meshData.drawState().indexType();
        }
        GpuBuffer gpuVertexBuffer = renderPipeline.getVertexFormat().uploadImmediateVertexBuffer(meshData.vertexBuffer());
        try (MeshData meshData2 = meshData;
             RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(target.getColorTexture(), OptionalInt.empty(), target.useDepth ? target.getDepthTexture() : null, OptionalDouble.empty());){
            ImmediateRenderUtil.prepareRenderPass(renderPass, renderPipeline);
            renderPass.setIndexBuffer(gpuIndexBuffer, gpuIndexType);
            renderPass.setVertexBuffer(0, gpuVertexBuffer);
            renderPass.drawIndexed(0, meshData.drawState().indexCount());
        }
    }

    public static void prepareRenderPass(RenderPass renderPass, RenderPipeline renderPipeline) {
        renderPass.setPipeline(renderPipeline);
        if (RenderSystem.SCISSOR_STATE.isEnabled()) {
            renderPass.enableScissor(RenderSystem.SCISSOR_STATE);
        }
        Services.PLATFORM.getPlatformRenderHelper().onPrepareRenderPass(renderPass);
        for (int textureIndex = 0; textureIndex < 12; ++textureIndex) {
            GpuTexture gpuTexture = RenderSystem.getShaderTexture((int)textureIndex);
            if (gpuTexture == null) continue;
            renderPass.bindSampler("Sampler" + textureIndex, gpuTexture);
        }
        for (RenderPipeline.UniformDescription uniform : renderPipeline.getUniforms()) {
            if (!CustomUniforms.isCustom(uniform)) continue;
            Object value = CustomUniforms.getUniformValue(uniform);
            if (value instanceof float[]) {
                renderPass.setUniform(uniform.name(), (float[])value);
                continue;
            }
            if (value instanceof int[]) {
                renderPass.setUniform(uniform.name(), (int[])value);
                continue;
            }
            if (value instanceof Matrix4f) {
                renderPass.setUniform(uniform.name(), (Matrix4f)value);
                continue;
            }
            throw new IllegalArgumentException("Render pipeline contains a custom uniform with an invalid value type: " + String.valueOf(value));
        }
    }
}

