/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import xaero.lib.XaeroLib;
import xaero.lib.client.graphics.GpuBufferSlice;

public class DynamicImmediateGpuBuffer {
    private GpuBuffer buffer;
    private final List<GpuBuffer> buffersToDelete;
    private int position;
    private final BufferType usage;

    public DynamicImmediateGpuBuffer(int initialSize, BufferType usage) {
        this.usage = usage;
        this.buffersToDelete = new ArrayList<GpuBuffer>();
        this.ensureBufferSize(initialSize);
    }

    private void ensureBufferSize(int requiredSize) {
        if (this.buffer != null && this.buffer.size() >= requiredSize) {
            return;
        }
        int newSize = this.buffer == null ? requiredSize : Math.max(requiredSize, this.buffer.size() * 2);
        GpuDevice gpuDevice = RenderSystem.getDevice();
        GpuBuffer resizedBuffer = gpuDevice.createBuffer(null, this.usage, BufferUsage.DYNAMIC_WRITE, newSize);
        if (this.buffer != null) {
            this.buffersToDelete.add(this.buffer);
            XaeroLib.LOGGER.info("Resized a dynamic immediate buffer to {}!", (Object)newSize);
        }
        this.buffer = resizedBuffer;
        this.position = 0;
    }

    public GpuBufferSlice allocateSlice(int size) {
        this.ensureBufferSize(this.position + size);
        GpuBufferSlice slice = new GpuBufferSlice(this.buffer, this.position, size);
        this.position += size;
        return slice;
    }

    public void clear() {
        this.position = 0;
        for (GpuBuffer gpuBuffer : this.buffersToDelete) {
            gpuBuffer.close();
        }
        this.buffersToDelete.clear();
    }

    public GpuBuffer getGpuBuffer() {
        return this.buffer;
    }
}

