/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;
import xaero.lib.client.graphics.shader.LibShaders;
import xaero.lib.client.graphics.shader.PositionTexAlphaTestShader;

public class ImmediateRenderUtil {
    public static void coloredRectangle(PoseStack matrices, float x1, float y1, float x2, float y2, int color) {
        ImmediateRenderUtil.coloredRectangle(matrices.last().pose(), x1, y1, x2, y2, color);
    }

    public static void coloredRectangle(Matrix4f matrix, float x1, float y1, float x2, float y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.getBuilder();
        vertexBuffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        vertexBuffer.vertex(matrix, x1, y2, 0.0f).color(r, g, b, a).endVertex();
        vertexBuffer.vertex(matrix, x2, y2, 0.0f).color(r, g, b, a).endVertex();
        vertexBuffer.vertex(matrix, x2, y1, 0.0f).color(r, g, b, a).endVertex();
        vertexBuffer.vertex(matrix, x1, y1, 0.0f).color(r, g, b, a).endVertex();
        tessellator.end();
    }

    public static void texturedRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        ImmediateRenderUtil.texturedRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, 0.0f, true);
    }

    public static void texturedRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha, boolean blend) {
        if (discardAlpha < 0.0f) {
            RenderSystem.setShader(blend ? () -> LibShaders.POSITION_TEX_NO_ALPHA_TEST : () -> LibShaders.POSITION_TEX_NO_ALPHA_TEST_NO_BLEND);
        } else {
            RenderSystem.setShader(blend ? () -> LibShaders.POSITION_TEX_ALPHA_TEST : () -> LibShaders.POSITION_TEX_ALPHA_TEST_NO_BLEND);
            ((PositionTexAlphaTestShader)RenderSystem.getShader()).setDiscardAlpha(discardAlpha);
        }
        ImmediateRenderUtil.texturedRectInternal(matrixStack, x, y, textureX, textureY, width, height, theight, factor);
    }

    private static void texturedRectInternal(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float textureH, float factor) {
        float f;
        float f1 = f = 1.0f / factor;
        Matrix4f matrix = matrixStack.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.getBuilder();
        vertexBuffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        vertexBuffer.vertex(matrix, x + 0.0f, y + height, 0.0f).uv((float)(textureX + 0) * f, (float)(textureY + 0) * f1).endVertex();
        vertexBuffer.vertex(matrix, x + width, y + height, 0.0f).uv(((float)textureX + width) * f, (float)(textureY + 0) * f1).endVertex();
        vertexBuffer.vertex(matrix, x + width, y + 0.0f, 0.0f).uv(((float)textureX + width) * f, ((float)textureY + textureH) * f1).endVertex();
        vertexBuffer.vertex(matrix, x + 0.0f, y + 0.0f, 0.0f).uv((float)(textureX + 0) * f, ((float)textureY + textureH) * f1).endVertex();
        tessellator.end();
    }

    public static void drawOutlineLayer(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha) {
        LibShaders.POSITION_TEX_ICON_OUTLINE.setDiscardAlpha(discardAlpha);
        RenderSystem.setShader(() -> LibShaders.POSITION_TEX_ICON_OUTLINE);
        ImmediateRenderUtil.texturedRectInternal(matrixStack, x, y, textureX, textureY, width, height, theight, factor);
    }
}

