/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.permission.system;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionType;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import xaero.lib.XaeroLib;
import xaero.lib.common.permission.PermissionNode;
import xaero.lib.common.permission.PermissionRegistry;
import xaero.lib.common.permission.system.IPermissionSystem;

public class NeoForgePermissionSystem
implements IPermissionSystem {
    private static final Map<PermissionNode<?>, net.neoforged.neoforge.server.permission.nodes.PermissionNode<?>> NODE_MAP = new HashMap();

    private <T> net.neoforged.neoforge.server.permission.nodes.PermissionNode<T> getNeo(PermissionNode<T> node) {
        return NODE_MAP.get(node);
    }

    @Override
    public boolean getBoolean(PermissionNode<Boolean> node, ServerPlayer player) {
        Boolean boxed = this.get(node, player);
        return boxed != null && boxed != false;
    }

    @Override
    public boolean getBooleanFast(PermissionNode<Boolean> node, ServerPlayer player) {
        return this.getBoolean(node, player);
    }

    @Override
    public <T> T get(PermissionNode<T> node, ServerPlayer player) {
        net.neoforged.neoforge.server.permission.nodes.PermissionNode<T> forgeNode = this.getNeo(node);
        if (forgeNode == null) {
            return null;
        }
        return (T)PermissionAPI.getPermission((ServerPlayer)player, forgeNode, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
    }

    @Override
    public <T> T getFast(PermissionNode<T> node, ServerPlayer player) {
        return this.get(node, player);
    }

    public static void registerNodes(PermissionGatherEvent.Nodes event) {
        for (String modId : PermissionRegistry.INSTANCE.getModIds()) {
            for (PermissionNode<?> node : PermissionRegistry.INSTANCE.getModNodes(modId)) {
                net.neoforged.neoforge.server.permission.nodes.PermissionNode<?> converted = NeoForgePermissionSystem.convert(node);
                event.addNodes(new net.neoforged.neoforge.server.permission.nodes.PermissionNode[]{converted});
                NODE_MAP.put(node, converted);
            }
        }
    }

    private static <T> net.neoforged.neoforge.server.permission.nodes.PermissionNode<T> convert(PermissionNode<T> node) {
        PermissionType type;
        Object object = node.getType() == Integer.class ? PermissionTypes.INTEGER : (node.getType() == Boolean.class ? PermissionTypes.BOOLEAN : (node.getType() == String.class ? PermissionTypes.STRING : (type = node.getType() == Component.class ? PermissionTypes.COMPONENT : null)));
        if (type == null) {
            XaeroLib.LOGGER.warn("Unimplemented node type for the Forge Permissions API: " + node.getType());
            return null;
        }
        return new net.neoforged.neoforge.server.permission.nodes.PermissionNode(node.getModId(), node.getActualPath(), type, (player, uuid, context) -> null, new PermissionDynamicContextKey[0]);
    }

    @Override
    public void handleModPresence(String modId) {
    }
}

