/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib;

import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingStage;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import xaero.lib.XaeroLib;
import xaero.lib.client.event.ClientEventsNeoForge;
import xaero.lib.client.event.ModClientEventsNeoForge;
import xaero.lib.common.event.CommonEventNeoForge;
import xaero.lib.common.packet.IPacketHandler;
import xaero.lib.common.packet.PacketHandlerNeoForge;
import xaero.lib.common.packet.PacketHandlerRegistry;
import xaero.lib.common.permission.system.NeoForgePermissionSystem;
import xaero.lib.common.permission.system.PermissionSystemRegistry;

@Mod(value="xaerolib")
public class XaeroLibNeoForge
extends XaeroLib {
    public XaeroLibNeoForge(IEventBus fmlEventBus) {
        this.registerEvents(fmlEventBus);
    }

    private void registerEvents(IEventBus fmlEventBus) {
        fmlEventBus.addListener(this::loadCommonNeoForge);
        fmlEventBus.addListener(this::loadClientNeoForge);
        fmlEventBus.addListener(this::loadServerNeoForge);
        fmlEventBus.addListener(this::registerPayloadHandlers);
        NeoForge.EVENT_BUS.register((Object)new CommonEventNeoForge());
        if (FMLLoader.getDist() == Dist.CLIENT) {
            this.registerClientEvents(fmlEventBus);
        }
    }

    private void registerClientEvents(IEventBus fmlEventBus) {
        ClientEventsNeoForge clientEvents = new ClientEventsNeoForge();
        NeoForge.EVENT_BUS.register((Object)clientEvents);
        fmlEventBus.register((Object)new ModClientEventsNeoForge(clientEvents));
    }

    private void loadCommonNeoForge(FMLCommonSetupEvent event) {
        this.loadCommon();
    }

    private void loadClientNeoForge(FMLClientSetupEvent event) {
        this.loadClient();
        ModContainer modContainer = ModList.get().getModContainerById("xaerolib").orElse(null);
        ModLoadingStage.SIDED_SETUP.getDeferredWorkQueue().enqueueWork(modContainer, this::deferredTaskClient);
    }

    private void loadServerNeoForge(FMLDedicatedServerSetupEvent event) {
        this.loadServer();
        ModContainer modContainer = ModList.get().getModContainerById("xaerolib").orElse(null);
        ModLoadingStage.SIDED_SETUP.getDeferredWorkQueue().enqueueWork(modContainer, this::deferredTaskServer);
    }

    public void registerPayloadHandlers(RegisterPayloadHandlerEvent event) {
        for (IPacketHandler packetHandler : PacketHandlerRegistry.INSTANCE) {
            if (!(packetHandler instanceof PacketHandlerNeoForge)) continue;
            PacketHandlerNeoForge packetHandlerNeoForge = (PacketHandlerNeoForge)packetHandler;
            packetHandlerNeoForge.registerPayloadHandler(event);
        }
    }

    @Override
    public void loadCommonLater() {
        PermissionSystemRegistry.INSTANCE.register(new NeoForgePermissionSystem());
        super.loadCommonLater();
    }

    private void deferredTaskClient() {
        this.loadCommonLater();
        this.loadClientLater();
    }

    private void deferredTaskServer() {
        this.loadCommonLater();
        this.loadServerLater();
    }
}

