/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;

public class XaeroRenderType
extends RenderType {
    public static final RenderStateShard.OutputStateShard KEEP_TARGET = new RenderStateShard.OutputStateShard("xaero_keep_target", () -> {}, () -> {});
    public static final RenderStateShard.TransparencyStateShard DEFAULT_TRANSLUCENT_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("xaero_translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderStateShard.TransparencyStateShard LINES_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("xaero_lines_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderStateShard.TransparencyStateShard PREMULTIPLIED_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("xaero_premultiplied_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderStateShard.TransparencyStateShard DEST_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("xaero_destination_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final float DEFAULT_POLYGON_OFFSET = 10.0f;
    public static final RenderStateShard.LayeringStateShard DEFAULT_POLYGON_OFFSET_LAYERING = new RenderStateShard.LayeringStateShard("xaero_polygon_offset_layering", () -> {
        RenderSystem.polygonOffset((float)0.0f, (float)10.0f);
        RenderSystem.enablePolygonOffset();
    }, () -> {
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
    });

    private XaeroRenderType(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static void resetDepthTest() {
        MultiPhaseBuilder.resetDepthTest();
    }

    public static void resetWriteMask() {
        MultiPhaseBuilder.resetWriteMask();
    }

    public static void resetTransparency() {
        MultiPhaseBuilder.resetTransparency();
    }

    public static RenderStateShard.TransparencyStateShard getTransparencyPhase(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        return new RenderStateShard.TransparencyStateShard("xaero_custom_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
    }

    public static class MultiPhaseBuilder
    extends RenderStateShard {
        private RenderStateShard.EmptyTextureStateShard texture = RenderStateShard.NO_TEXTURE;
        private RenderStateShard.ShaderStateShard shader = RenderStateShard.NO_SHADER;
        private RenderStateShard.TransparencyStateShard transparency = RenderStateShard.NO_TRANSPARENCY;
        private RenderStateShard.DepthTestStateShard depthTest = RenderStateShard.LEQUAL_DEPTH_TEST;
        private RenderStateShard.CullStateShard cull = RenderStateShard.CULL;
        private RenderStateShard.LightmapStateShard lightmap = RenderStateShard.NO_LIGHTMAP;
        private RenderStateShard.OverlayStateShard overlay = RenderStateShard.NO_OVERLAY;
        private RenderStateShard.LayeringStateShard layering = RenderStateShard.NO_LAYERING;
        private RenderStateShard.OutputStateShard target = RenderStateShard.MAIN_TARGET;
        private RenderStateShard.TexturingStateShard texturing = RenderStateShard.DEFAULT_TEXTURING;
        private RenderStateShard.WriteMaskStateShard writeMaskState = RenderStateShard.COLOR_DEPTH_WRITE;
        private RenderStateShard.LineStateShard lineWidth = RenderStateShard.DEFAULT_LINE;

        public MultiPhaseBuilder() {
            super("weird access error workaround", null, null);
        }

        public MultiPhaseBuilder texture(RenderStateShard.EmptyTextureStateShard texture) {
            this.texture = texture;
            return this;
        }

        public MultiPhaseBuilder shader(RenderStateShard.ShaderStateShard shader) {
            this.shader = shader;
            return this;
        }

        public MultiPhaseBuilder transparency(RenderStateShard.TransparencyStateShard transparency) {
            this.transparency = transparency;
            return this;
        }

        public MultiPhaseBuilder depthTest(RenderStateShard.DepthTestStateShard depthTest) {
            this.depthTest = depthTest;
            return this;
        }

        public MultiPhaseBuilder cull(RenderStateShard.CullStateShard cull) {
            this.cull = cull;
            return this;
        }

        public MultiPhaseBuilder lightmap(RenderStateShard.LightmapStateShard lightmap) {
            this.lightmap = lightmap;
            return this;
        }

        public MultiPhaseBuilder overlay(RenderStateShard.OverlayStateShard overlay) {
            this.overlay = overlay;
            return this;
        }

        public MultiPhaseBuilder layering(RenderStateShard.LayeringStateShard layering) {
            this.layering = layering;
            return this;
        }

        public MultiPhaseBuilder target(RenderStateShard.OutputStateShard target) {
            this.target = target;
            return this;
        }

        public MultiPhaseBuilder texturing(RenderStateShard.TexturingStateShard texturing) {
            this.texturing = texturing;
            return this;
        }

        public MultiPhaseBuilder writeMaskState(RenderStateShard.WriteMaskStateShard writeMaskState) {
            this.writeMaskState = writeMaskState;
            return this;
        }

        public MultiPhaseBuilder lineWidth(RenderStateShard.LineStateShard lineWidth) {
            this.lineWidth = lineWidth;
            return this;
        }

        public ImmutableList<RenderStateShard> build() {
            return ImmutableList.of((Object)this.texture, (Object)this.shader, (Object)this.transparency, (Object)this.depthTest, (Object)this.cull, (Object)this.lightmap, (Object)this.overlay, (Object)this.layering, (Object)this.target, (Object)this.texturing, (Object)this.writeMaskState, (Object)this.lineWidth, (Object[])new RenderStateShard[0]);
        }

        public static void resetDepthTest() {
            RenderStateShard.EQUAL_DEPTH_TEST.setupRenderState();
            RenderStateShard.EQUAL_DEPTH_TEST.clearRenderState();
        }

        public static void resetWriteMask() {
            RenderStateShard.COLOR_WRITE.setupRenderState();
            RenderStateShard.COLOR_WRITE.clearRenderState();
            RenderStateShard.DEPTH_WRITE.setupRenderState();
            RenderStateShard.DEPTH_WRITE.clearRenderState();
        }

        public static void resetTransparency() {
            RenderStateShard.ADDITIVE_TRANSPARENCY.setupRenderState();
            RenderStateShard.ADDITIVE_TRANSPARENCY.clearRenderState();
        }
    }

    public static class MultiPhaseRenderType
    extends RenderType {
        public MultiPhaseRenderType(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, ImmutableList<RenderStateShard> phases) {
            super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, () -> phases.forEach(RenderStateShard::setupRenderState), () -> phases.forEach(RenderStateShard::clearRenderState));
        }
    }
}

