/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.opengl.BufferStorage;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import xaero.lib.XaeroLib;

public class DynamicImmediateGpuBuffer {
    private GpuBuffer buffer;
    private final List<GpuBuffer> buffersToDelete;
    private long position;
    private final int usageFlags;
    private final boolean usesImmutableBufferStorage;

    public DynamicImmediateGpuBuffer(int initialSize, int usageFlags) {
        this.usageFlags = usageFlags;
        this.buffersToDelete = new ArrayList<GpuBuffer>();
        if (RenderSystem.getDevice().getBackendName().equals("OpenGL")) {
            HashSet storageTestSet = new HashSet();
            BufferStorage.create((GLCapabilities)GL.getCapabilities(), storageTestSet);
            this.usesImmutableBufferStorage = storageTestSet.contains("GL_ARB_buffer_storage");
        } else {
            this.usesImmutableBufferStorage = true;
        }
        this.ensureBufferSize(initialSize);
    }

    private void ensureBufferSize(long requiredSize) {
        if (this.buffer != null && this.buffer.size() >= requiredSize) {
            return;
        }
        long newSize = this.buffer == null ? requiredSize : Math.max(requiredSize, this.buffer.size() * 2L);
        GpuDevice gpuDevice = RenderSystem.getDevice();
        int additionalUsageFlags = this.usesImmutableBufferStorage ? 0 : 6;
        GpuBuffer resizedBuffer = gpuDevice.createBuffer(null, this.usageFlags | 8 | additionalUsageFlags, newSize);
        if (this.buffer != null) {
            this.buffersToDelete.add(this.buffer);
            XaeroLib.LOGGER.info("Resized a dynamic immediate buffer to {}!", (Object)newSize);
        }
        this.buffer = resizedBuffer;
        this.position = 0L;
    }

    public GpuBufferSlice allocateSlice(long size) {
        this.ensureBufferSize(this.position + size);
        GpuBufferSlice slice = this.buffer.slice(this.position, size);
        this.position += size;
        return slice;
    }

    public void clear() {
        this.position = 0L;
        for (GpuBuffer gpuBuffer : this.buffersToDelete) {
            gpuBuffer.close();
        }
        this.buffersToDelete.clear();
    }

    public GpuBuffer getGpuBuffer() {
        return this.buffer;
    }
}

