/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.platform.services;

import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LoadingModList;
import xaero.lib.client.controls.util.IKeyMappingHelper;
import xaero.lib.client.controls.util.KeyMappingHelperNeoForge;
import xaero.lib.client.graphics.util.IPlatformRenderHelper;
import xaero.lib.client.graphics.util.RenderHelperNeoForge;
import xaero.lib.common.compat.NeoForgeModCompatibility;
import xaero.lib.common.compat.PlatformModCompatibility;
import xaero.lib.common.packet.IPacketHandler;
import xaero.lib.common.packet.PacketHandlerNeoForge;
import xaero.lib.common.reflection.util.ObfuscatedReflectionNeoForge;
import xaero.lib.platform.services.IPlatformHelper;

public class PlatformHelperNeoForge
implements IPlatformHelper {
    private final KeyMappingHelperNeoForge keyMappingHelper = new KeyMappingHelperNeoForge();
    private final RenderHelperNeoForge renderHelper = new RenderHelperNeoForge();
    private final ObfuscatedReflectionNeoForge obfuscatedReflection = new ObfuscatedReflectionNeoForge();

    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean checkModForMixin(String modId) {
        return LoadingModList.get().getModFileById(modId) != null;
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public boolean isDedicatedServer() {
        return FMLLoader.getDist() == Dist.DEDICATED_SERVER;
    }

    @Override
    public IKeyMappingHelper getKeyMappingHelper() {
        return this.keyMappingHelper;
    }

    @Override
    public IPlatformRenderHelper getPlatformRenderHelper() {
        return this.renderHelper;
    }

    @Override
    public ObfuscatedReflectionNeoForge getObfuscatedReflection() {
        return this.obfuscatedReflection;
    }

    @Override
    public IPacketHandler createPacketHandler(ResourceLocation channelId, int protocolVersion, String protocolVersionString) {
        return PacketHandlerNeoForge.Builder.begin().setChannelId(channelId).setProtocolVersion(protocolVersionString).build();
    }

    @Override
    public PlatformModCompatibility createPlatformModCompatibility() {
        return new NeoForgeModCompatibility();
    }

    @Override
    public Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }
}

