/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet;

import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import xaero.lib.common.packet.PacketHandlerFull;
import xaero.lib.common.packet.PacketPayloadHandler;
import xaero.lib.common.packet.payload.PacketPayloadCodec;
import xaero.lib.common.packet.type.PacketTypeManager;

public class PacketHandlerNeoForge
extends PacketHandlerFull {
    private final String protocolVersion;

    private PacketHandlerNeoForge(ResourceLocation channelId, String protocolVersion) {
        super(channelId, PacketTypeManager.Builder.begin().build(), new CustomPacketPayload.Type(channelId));
        this.protocolVersion = protocolVersion;
    }

    public void registerPayloadHandler(RegisterPayloadHandlersEvent event) {
        event.registrar(this.channelId.getNamespace()).versioned(this.protocolVersion).optional().playBidirectional(this.type, (StreamCodec)new PacketPayloadCodec(this), (IPayloadHandler)new PacketPayloadHandler());
    }

    public <P> void sendToServer(P packet) {
        PacketDistributor.sendToServer(this.createPayload(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public <P> void sendToPlayer(ServerPlayer player, P packet) {
        if (!player.connection.hasChannel(this.channelId)) {
            return;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, this.createPayload(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static final class Builder {
        private ResourceLocation channelId;
        private String protocolVersion;

        private Builder() {
        }

        public Builder setDefault() {
            this.setChannelId(null);
            this.setProtocolVersion(null);
            return this;
        }

        public Builder setChannelId(ResourceLocation channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder setProtocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public PacketHandlerNeoForge build() {
            if (this.channelId == null || this.protocolVersion == null) {
                throw new IllegalStateException();
            }
            return new PacketHandlerNeoForge(this.channelId, this.protocolVersion);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

