/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics.shader;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class CustomUniforms {
    private static Map<RenderPipeline.UniformDescription, Supplier<Object>> UNIFORM_VALUE_GETTERS = new HashMap<RenderPipeline.UniformDescription, Supplier<Object>>();

    public static void register(RenderPipeline.UniformDescription uniform, Supplier<Object> valueGetter) {
        if (UNIFORM_VALUE_GETTERS.containsKey(uniform)) {
            throw new IllegalArgumentException("Custom uniform already registered: " + String.valueOf(uniform));
        }
        UNIFORM_VALUE_GETTERS.put(uniform, valueGetter);
    }

    public static Object getUniformValue(RenderPipeline.UniformDescription uniform) {
        Supplier<Object> getter = UNIFORM_VALUE_GETTERS.get(uniform);
        return getter == null ? null : getter.get();
    }

    public static boolean isCustom(RenderPipeline.UniformDescription uniform) {
        return UNIFORM_VALUE_GETTERS.containsKey(uniform);
    }
}

