/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.shaders.UniformType;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import xaero.lib.client.graphics.ICompositeRenderType;
import xaero.lib.client.graphics.ICompositeState;
import xaero.lib.client.graphics.shader.BuiltInCustomUniforms;
import xaero.lib.client.graphics.shader.LibShaders;
import xaero.lib.client.graphics.util.ImmediateRenderUtil;
import xaero.lib.common.reflection.util.ReflectionUtils;

public class XaeroRenderType
extends RenderType
implements ICompositeRenderType {
    private final RenderType vanillaCompositeRenderType;
    private final RenderPipeline renderPipeline;
    private final RenderType.CompositeState compositeState;
    private final RenderStateShard.OutputStateShard outputStateShard;
    public static final VertexFormat POSITION_COLOR_TEX = VertexFormat.builder().add("Position", VertexFormatElement.POSITION).add("Color", VertexFormatElement.COLOR).add("UV0", VertexFormatElement.UV0).build();
    protected static final BlendFunction DEFAULT_TRANSLUCENT_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA);
    protected static final BlendFunction LINES_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA);
    protected static final BlendFunction PREMULTIPLIED_TRANSPARENCY = new BlendFunction(SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA);
    protected static final BlendFunction NEGATIVE_TRANSPARENCY = new BlendFunction(SourceFactor.ONE_MINUS_DST_COLOR, DestFactor.ZERO, SourceFactor.ZERO, DestFactor.ONE);
    protected static final BlendFunction DEST_TRANSPARENCY = new BlendFunction(SourceFactor.ONE, DestFactor.ZERO, SourceFactor.ZERO, DestFactor.ONE);
    protected static final BlendFunction REPLACE_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ZERO, SourceFactor.ONE, DestFactor.ZERO);
    protected static final BlendFunction ADD_ALPHA_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE);
    public static final RenderPipeline RP_POSITION_TEX_ALPHA;
    public static final RenderPipeline RP_POSITION_TEX_ALPHA_NO_BLEND;
    public static final RenderPipeline RP_POSITION_TEX_NO_ALPHA;
    public static final RenderPipeline RP_POSITION_TEX_NO_ALPHA_NO_DEPTH;
    public static final RenderPipeline RP_POSITION_TEX_NO_ALPHA_NO_BLEND;
    public static final RenderPipeline RP_POSITION_TEX_ALPHA_REPLACE;
    public static final RenderPipeline RP_POSITION_TEX_ALPHA_NO_CULL;
    public static final RenderPipeline RP_POSITION;
    public static final RenderPipeline RP_POSITION_NO_DEPTH;
    public static final RenderPipeline RP_NEGATIVE_COLOR;
    public static final RenderPipeline RP_ICON_OUTLINE;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_TRANSLUCENT;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_TRANSLUCENT_NO_DEPTH;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_TRANSLUCENT_CULL;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_PREMULTIPLIED;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_NO_BLEND;
    public static final RenderPipeline RP_POSITION_COLOR_TRANSLUCENT;
    public static final RenderPipeline RP_POSITION_COLOR_NO_BLEND;
    public static final RenderPipeline RP_POSITION_COLOR_NO_CULL;
    public static final RenderPipeline RP_LINES;
    public static final RenderPipeline RP_DEPTH_CLEAR;
    public static final RenderPipeline RP_MAP;
    public static final RenderPipeline RP_MAP_BRANCH;
    public static final RenderPipeline RP_MAP_FRAME;
    public static final RenderPipeline RP_COLOR_FILLER;
    private static final Method compositeStateBuilderMethod;
    private static final Method compositeStateBuilderCreateCompositeStateMethod;
    private static final Method compositeStateBuilderSetTextureStateMethod;
    private static final Method compositeStateBuilderSetLightmapStateMethod;
    private static final Method compositeStateBuilderSetOverlayStateMethod;
    private static final Method compositeStateBuilderSetLayeringStateMethod;
    private static final Method compositeStateBuilderSetOutputStateMethod;
    private static final Method compositeStateBuilderSetTexturingStateMethod;
    private static final Method compositeStateBuilderSetLineStateMethod;
    private static final Method renderTypeCreateMethod;

    public XaeroRenderType(String name, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, RenderPipeline renderPipeline, RenderStateShard.OutputStateShard outputStateShard, RenderType.CompositeState compositeState, RenderType vanillaCompositeRenderType) {
        super(name, bufferSize, affectsCrumbling, sortOnUpload, () -> ((RenderType)vanillaCompositeRenderType).setupRenderState(), () -> ((RenderType)vanillaCompositeRenderType).clearRenderState());
        this.renderPipeline = renderPipeline;
        this.outputStateShard = outputStateShard;
        this.compositeState = compositeState;
        this.vanillaCompositeRenderType = vanillaCompositeRenderType;
    }

    public void draw(@Nonnull MeshData meshData) {
        this.setupRenderState();
        ImmediateRenderUtil.drawImmediateMeshData(meshData, this.renderPipeline, this.outputStateShard.getRenderTarget());
        this.clearRenderState();
    }

    @Nonnull
    public VertexFormat format() {
        return this.vanillaCompositeRenderType.format();
    }

    @Nonnull
    public VertexFormat.Mode mode() {
        return this.vanillaCompositeRenderType.mode();
    }

    @Override
    public RenderPipeline xaero_lib_getRenderPipeline() {
        return this.renderPipeline;
    }

    @Override
    public ICompositeState xaero_lib_getState() {
        return (ICompositeState)this.compositeState;
    }

    public static RenderPipeline getBasicRenderPipeline() {
        return RenderPipelines.ENTITY_TRANSLUCENT;
    }

    public static CustomStateBuilder getStateBuilder() {
        return new CustomStateBuilder((RenderType.CompositeState.CompositeStateBuilder)ReflectionUtils.getReflectMethodValue(null, compositeStateBuilderMethod, new Object[0]));
    }

    public static RenderType createRenderType(String name, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, RenderPipeline renderPipeline, CustomStateBuilder stateBuilder, RenderType.OutlineProperty outlineProperty) {
        RenderType.CompositeState compositeState = stateBuilder.createCompositeState(outlineProperty);
        RenderType normalRenderType = (RenderType)ReflectionUtils.getReflectMethodValue(null, renderTypeCreateMethod, name, bufferSize, affectsCrumbling, sortOnUpload, renderPipeline, compositeState);
        return new XaeroRenderType(name, bufferSize, affectsCrumbling, sortOnUpload, renderPipeline, stateBuilder.getOutputState(), compositeState, normalRenderType);
    }

    public static RenderTarget getOutputStateTarget(Object outputStateShard) {
        return ((RenderStateShard.OutputStateShard)outputStateShard).getRenderTarget();
    }

    static {
        try {
            Class<?> compositeStateClass = ReflectionUtils.getClassForName("net.minecraft.class_1921$class_4688", "net.minecraft.client.renderer.RenderType$CompositeState");
            compositeStateBuilderMethod = ReflectionUtils.getMethodReflection(compositeStateClass, "builder", "method_23598", "()Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110628_", new Class[0]);
            compositeStateBuilderCreateCompositeStateMethod = ReflectionUtils.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "createCompositeState", "method_24297", "(Lnet/minecraft/class_1921$class_4750;)Lnet/minecraft/class_1921$class_4688;", "m_110689_", RenderType.OutlineProperty.class);
            compositeStateBuilderSetTextureStateMethod = ReflectionUtils.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setTextureState", "method_34577", "(Lnet/minecraft/class_4668$class_5939;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_173290_", RenderStateShard.EmptyTextureStateShard.class);
            compositeStateBuilderSetLightmapStateMethod = ReflectionUtils.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setLightmapState", "method_23608", "(Lnet/minecraft/class_4668$class_4676;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110671_", RenderStateShard.LightmapStateShard.class);
            compositeStateBuilderSetOverlayStateMethod = ReflectionUtils.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setOverlayState", "method_23611", "(Lnet/minecraft/class_4668$class_4679;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110677_", RenderStateShard.OverlayStateShard.class);
            compositeStateBuilderSetLayeringStateMethod = ReflectionUtils.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setLayeringState", "method_23607", "(Lnet/minecraft/class_4668$class_4675;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110669_", RenderStateShard.LayeringStateShard.class);
            compositeStateBuilderSetOutputStateMethod = ReflectionUtils.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setOutputState", "method_23610", "(Lnet/minecraft/class_4668$class_4678;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110675_", RenderStateShard.OutputStateShard.class);
            compositeStateBuilderSetTexturingStateMethod = ReflectionUtils.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setTexturingState", "method_23614", "(Lnet/minecraft/class_4668$class_4684;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110683_", RenderStateShard.TexturingStateShard.class);
            compositeStateBuilderSetLineStateMethod = ReflectionUtils.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setLineState", "method_23609", "(Lnet/minecraft/class_4668$class_4677;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110673_", RenderStateShard.LineStateShard.class);
            renderTypeCreateMethod = ReflectionUtils.getMethodReflection(RenderType.class, "create", "method_24049", "(Ljava/lang/String;IZZLcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/class_1921$class_4688;)Lnet/minecraft/class_1921$class_4687;", "m_173215_", String.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, RenderPipeline.class, RenderType.CompositeState.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        RenderPipeline.Snippet MATRICES_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[0]).withUniform("DynamicTransforms", UniformType.UNIFORM_BUFFER).withUniform("Projection", UniformType.UNIFORM_BUFFER).buildSnippet();
        RenderPipeline.Snippet MATRICES_FOG_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withUniform("Fog", UniformType.UNIFORM_BUFFER).buildSnippet();
        RenderPipeline.Snippet POSITION_TEX_NO_ALPHA_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(LibShaders.POSITION_TEX_NO_ALPHA_TEST).withFragmentShader(LibShaders.POSITION_TEX_NO_ALPHA_TEST).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).withSampler("Sampler0").buildSnippet();
        RP_POSITION_TEX_NO_ALPHA = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_TEX_NO_ALPHA_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_tex_no_alpha")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).build();
        RP_POSITION_TEX_NO_ALPHA_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_TEX_NO_ALPHA_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_tex_no_alpha_no_depth")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        RP_POSITION_TEX_NO_ALPHA_NO_BLEND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_TEX_NO_ALPHA_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_tex_no_alpha_no_blend")).withoutBlend().build();
        RenderPipeline.Snippet RP_POSITION_TEX_ALPHA_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(LibShaders.POSITION_TEX_ALPHA_TEST).withFragmentShader(LibShaders.POSITION_TEX_ALPHA_TEST).withUniform(BuiltInCustomUniforms.DISCARD_ALPHA.name(), BuiltInCustomUniforms.DISCARD_ALPHA.type()).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).withSampler("Sampler0").buildSnippet();
        RP_POSITION_TEX_ALPHA = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_tex_alpha")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).build();
        RP_ICON_OUTLINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/icon_outline")).withBlend(ADD_ALPHA_TRANSPARENCY).build();
        RP_POSITION_TEX_ALPHA_NO_BLEND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_tex_alpha_no_blend")).withoutBlend().build();
        RP_POSITION_TEX_ALPHA_REPLACE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_tex_alpha_replace")).withBlend(REPLACE_TRANSPARENCY).build();
        RP_POSITION_TEX_ALPHA_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_tex_alpha_no_cull")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withCull(false).build();
        RP_POSITION = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos")).withVertexShader("core/position").withFragmentShader("core/position").withVertexFormat(DefaultVertexFormat.POSITION, VertexFormat.Mode.QUADS).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).build();
        RP_POSITION_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos")).withVertexShader("core/position").withFragmentShader("core/position").withVertexFormat(DefaultVertexFormat.POSITION, VertexFormat.Mode.QUADS).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        RP_NEGATIVE_COLOR = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_negative_color")).withVertexShader("core/position").withFragmentShader("core/position").withVertexFormat(DefaultVertexFormat.POSITION, VertexFormat.Mode.QUADS).withBlend(NEGATIVE_TRANSPARENCY).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        RenderPipeline.Snippet POSITION_COLOR_TEX_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(LibShaders.POSITION_COLOR_TEX).withFragmentShader(LibShaders.POSITION_COLOR_TEX).withVertexFormat(POSITION_COLOR_TEX, VertexFormat.Mode.QUADS).withSampler("Sampler0").buildSnippet();
        RenderPipeline.Snippet POSITION_COLOR_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(LibShaders.POSITION_COLOR).withFragmentShader(LibShaders.POSITION_COLOR).withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS).buildSnippet();
        RenderPipeline.Snippet POSITION_COLOR_NO_ALPHA_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(LibShaders.POSITION_COLOR_NO_ALPHA_TEST).withFragmentShader(LibShaders.POSITION_COLOR_NO_ALPHA_TEST).withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS).buildSnippet();
        RP_POSITION_COLOR_TEX_TRANSLUCENT = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_col_tex_translucent")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withCull(false).build();
        RP_POSITION_COLOR_TEX_TRANSLUCENT_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_col_tex_translucent_cull")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).build();
        RP_POSITION_COLOR_TEX_TRANSLUCENT_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_col_tex_translucent_no_depth")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withCull(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        RP_POSITION_COLOR_TEX_PREMULTIPLIED = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_col_tex_premultiplied")).withBlend(PREMULTIPLIED_TRANSPARENCY).withCull(false).build();
        RP_POSITION_COLOR_TEX_NO_BLEND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_col_tex_no_blend")).withoutBlend().build();
        RP_POSITION_COLOR_TRANSLUCENT = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_col_translucent")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).build();
        RP_POSITION_COLOR_NO_BLEND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_col_no_blend")).withoutBlend().build();
        RP_POSITION_COLOR_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_col_translucent")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withCull(false).build();
        RP_LINES = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/lines")).withVertexShader(LibShaders.FRAMEBUFFER_LINES).withFragmentShader(LibShaders.FRAMEBUFFER_LINES).withUniform(BuiltInCustomUniforms.FRAME_SIZE.name(), BuiltInCustomUniforms.FRAME_SIZE.type()).withVertexFormat(DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES).withBlend(LINES_TRANSPARENCY).build();
        RP_DEPTH_CLEAR = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_NO_ALPHA_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/depth_clear")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withDepthTestFunction(DepthTestFunction.GREATER_DEPTH_TEST).withColorWrite(false, false).build();
        RP_MAP = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/map")).withVertexShader(LibShaders.WORLD_MAP).withFragmentShader(LibShaders.WORLD_MAP).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).withSampler("Sampler0").withUniform(BuiltInCustomUniforms.BRIGHTNESS.name(), BuiltInCustomUniforms.BRIGHTNESS.type()).withUniform(BuiltInCustomUniforms.WITH_LIGHT.name(), BuiltInCustomUniforms.WITH_LIGHT.type()).withBlend(DEST_TRANSPARENCY).withCull(false).build();
        RP_MAP_BRANCH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/map_branch")).withVertexShader(LibShaders.WORLD_MAP_BRANCH).withFragmentShader(LibShaders.WORLD_MAP_BRANCH).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).withSampler("Sampler0").withoutBlend().withCull(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withDepthWrite(false).build();
        RP_MAP_FRAME = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/map_frame")).withBlend(DEST_TRANSPARENCY).withCull(false).withDepthWrite(false).build();
        RP_COLOR_FILLER = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/color_filler")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withDepthWrite(false).build();
    }

    public static final class CustomStateBuilder {
        private final RenderType.CompositeState.CompositeStateBuilder original;
        private RenderStateShard.OutputStateShard outputState = RenderStateShard.MAIN_TARGET;

        private CustomStateBuilder(RenderType.CompositeState.CompositeStateBuilder original) {
            this.original = original;
        }

        public CustomStateBuilder setTextureState(RenderStateShard.EmptyTextureStateShard textureState) {
            ReflectionUtils.getReflectMethodValue(this.original, compositeStateBuilderSetTextureStateMethod, textureState);
            return this;
        }

        public CustomStateBuilder setLightmapState(RenderStateShard.LightmapStateShard lightmapState) {
            ReflectionUtils.getReflectMethodValue(this.original, compositeStateBuilderSetLightmapStateMethod, lightmapState);
            return this;
        }

        public CustomStateBuilder setOverlayState(RenderStateShard.OverlayStateShard overlayState) {
            ReflectionUtils.getReflectMethodValue(this.original, compositeStateBuilderSetOverlayStateMethod, overlayState);
            return this;
        }

        public CustomStateBuilder setLayeringState(RenderStateShard.LayeringStateShard layeringState) {
            ReflectionUtils.getReflectMethodValue(this.original, compositeStateBuilderSetLayeringStateMethod, layeringState);
            return this;
        }

        public CustomStateBuilder setOutputState(RenderStateShard.OutputStateShard outputState) {
            ReflectionUtils.getReflectMethodValue(this.original, compositeStateBuilderSetOutputStateMethod, outputState);
            this.outputState = outputState;
            return this;
        }

        public CustomStateBuilder setTexturingState(RenderStateShard.TexturingStateShard texturingState) {
            ReflectionUtils.getReflectMethodValue(this.original, compositeStateBuilderSetTexturingStateMethod, texturingState);
            return this;
        }

        public CustomStateBuilder setLineState(RenderStateShard.LineStateShard lineState) {
            ReflectionUtils.getReflectMethodValue(this.original, compositeStateBuilderSetLineStateMethod, lineState);
            return this;
        }

        public RenderStateShard.OutputStateShard getOutputState() {
            return this.outputState;
        }

        private RenderType.CompositeState createCompositeState(RenderType.OutlineProperty outlineProperty) {
            return (RenderType.CompositeState)ReflectionUtils.getReflectMethodValue(this.original, compositeStateBuilderCreateCompositeStateMethod, outlineProperty);
        }
    }
}

