/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics.shader;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import xaero.lib.XaeroLib;
import xaero.lib.client.graphics.XaeroRenderType;
import xaero.lib.client.graphics.shader.FramebufferLinesShader;
import xaero.lib.client.graphics.shader.PositionTexAlphaTestShader;
import xaero.lib.client.graphics.shader.WorldMapShader;

public class LibShaders {
    public static FramebufferLinesShader FRAMEBUFFER_LINES = null;
    public static ShaderInstance POSITION_COLOR_TEX = null;
    public static ShaderInstance POSITION_COLOR_TEX_PRE = null;
    public static ShaderInstance POSITION_COLOR = null;
    public static ShaderInstance POSITION_COLOR_NO_ALPHA_TEST = null;
    public static ShaderInstance POSITION_TEX_NO_ALPHA_TEST = null;
    public static ShaderInstance POSITION_TEX_NO_ALPHA_TEST_NO_BLEND = null;
    public static PositionTexAlphaTestShader POSITION_TEX_ALPHA_TEST = null;
    public static PositionTexAlphaTestShader POSITION_TEX_ALPHA_TEST_NO_BLEND = null;
    public static PositionTexAlphaTestShader POSITION_TEX_ICON_OUTLINE = null;
    public static WorldMapShader WORLD_MAP = null;
    public static ShaderInstance WORLD_MAP_BRANCH = null;
    private static boolean firstTime = true;

    public static void onResourceReload(ResourceManager resourceManager) {
        String errorMessage = "Couldn't reload the XaeroLib shaders!";
        try {
            FRAMEBUFFER_LINES = LibShaders.reloadShader(FRAMEBUFFER_LINES, new FramebufferLinesShader((ResourceProvider)resourceManager));
            POSITION_COLOR_TEX = LibShaders.reloadShader(POSITION_COLOR_TEX, new ShaderInstance((ResourceProvider)resourceManager, "xaerolib/position_color_tex", XaeroRenderType.POSITION_COLOR_TEX));
            POSITION_COLOR_TEX_PRE = LibShaders.reloadShader(POSITION_COLOR_TEX_PRE, new ShaderInstance((ResourceProvider)resourceManager, "xaerolib/position_color_tex_pre", XaeroRenderType.POSITION_COLOR_TEX));
            POSITION_COLOR = LibShaders.reloadShader(POSITION_COLOR, new ShaderInstance((ResourceProvider)resourceManager, "xaerolib/position_color", XaeroRenderType.POSITION_COLOR_TEX));
            POSITION_COLOR_NO_ALPHA_TEST = LibShaders.reloadShader(POSITION_COLOR_NO_ALPHA_TEST, new ShaderInstance((ResourceProvider)resourceManager, "xaerolib/position_color_no_alpha_test", XaeroRenderType.POSITION_COLOR_TEX));
            POSITION_TEX_NO_ALPHA_TEST = LibShaders.reloadShader(POSITION_TEX_NO_ALPHA_TEST, new ShaderInstance((ResourceProvider)resourceManager, "xaerolib/pos_tex_no_alpha_test", DefaultVertexFormat.POSITION_TEX));
            POSITION_TEX_NO_ALPHA_TEST_NO_BLEND = LibShaders.reloadShader(POSITION_TEX_NO_ALPHA_TEST_NO_BLEND, new ShaderInstance((ResourceProvider)resourceManager, "xaerolib/pos_tex_no_alpha_test_no_blend", DefaultVertexFormat.POSITION_TEX));
            POSITION_TEX_ALPHA_TEST = LibShaders.reloadShader(POSITION_TEX_ALPHA_TEST, new PositionTexAlphaTestShader((ResourceProvider)resourceManager, "xaerolib/pos_tex_alpha_test"));
            POSITION_TEX_ALPHA_TEST_NO_BLEND = LibShaders.reloadShader(POSITION_TEX_ALPHA_TEST_NO_BLEND, new PositionTexAlphaTestShader((ResourceProvider)resourceManager, "xaerolib/pos_tex_alpha_test_no_blend"));
            POSITION_TEX_ICON_OUTLINE = LibShaders.reloadShader(POSITION_TEX_ICON_OUTLINE, new PositionTexAlphaTestShader((ResourceProvider)resourceManager, "xaerolib/pos_tex_icon_outline"));
            WORLD_MAP = LibShaders.reloadShader(WORLD_MAP, new WorldMapShader((ResourceProvider)resourceManager));
            WORLD_MAP_BRANCH = LibShaders.reloadShader(WORLD_MAP_BRANCH, new ShaderInstance((ResourceProvider)resourceManager, "xaerolib/map_branch", DefaultVertexFormat.POSITION_TEX));
            XaeroLib.LOGGER.info("Successfully reloaded the XaeroLib shaders!");
        }
        catch (IOException e) {
            if (firstTime) {
                throw new RuntimeException("Couldn't reload the XaeroLib shaders!", e);
            }
            XaeroLib.LOGGER.error("Couldn't reload the XaeroLib shaders!", (Throwable)e);
        }
        firstTime = false;
    }

    private static <S extends ShaderInstance> S reloadShader(S current, S newOne) throws IOException {
        if (current != null) {
            current.close();
        }
        return newOne;
    }

    public static void ensureShaders() {
        if (FRAMEBUFFER_LINES == null && firstTime) {
            LibShaders.onResourceReload(Minecraft.getInstance().getResourceManager());
        }
    }
}

