/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet;

import javax.annotation.Nonnull;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import xaero.lib.common.packet.payload.PacketPayload;
import xaero.lib.common.packet.type.PacketType;

public class PacketPayloadHandler
implements IPayloadHandler<PacketPayload<?>> {
    public void handle(@Nonnull PacketPayload<?> payload, @Nonnull IPayloadContext context) {
        this.handleTyped(payload, context);
    }

    private <P> void handleTyped(PacketPayload<P> payload, IPayloadContext context) {
        PacketType packetType = payload.getPacketType();
        if (packetType == null) {
            return;
        }
        Object packet = payload.getPacket();
        if (packet == null) {
            return;
        }
        if (context.flow() == PacketFlow.CLIENTBOUND) {
            if (packetType.getClientHandler() == null) {
                return;
            }
            context.enqueueWork(() -> packetType.getClientHandler().accept(packet));
            return;
        }
        if (packetType.getServerHandler() == null) {
            return;
        }
        if (context.flow() != PacketFlow.SERVERBOUND) {
            return;
        }
        ServerPlayer player = (ServerPlayer)context.player();
        context.enqueueWork(() -> packetType.getServerHandler().accept(packet, player));
    }
}

