/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.util.task.GetServerDetailsTask;
import java.lang.reflect.Field;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import xaero.lib.common.reflection.util.ReflectionUtils;
import xaero.lib.patreon.Patreon;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.mods.SupportMods;

public class ClientEvents {
    private RealmsServer latestRealm;
    private Field realmsTaskField;
    private Field realmsTaskServerField;

    public Screen handleGuiOpen(Screen gui) {
        if (gui instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                GetServerDetailsTask realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    this.realmsTaskField = ReflectionUtils.getFieldReflection(RealmsLongRunningMcoTaskScreen.class, (String)"task", (String)"field_19919", (String)"Lnet/minecraft/class_4358;", (String)"f_88773_");
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    this.realmsTaskServerField = ReflectionUtils.getFieldReflection(GetServerDetailsTask.class, (String)"server", (String)"field_20224", (String)"Lnet/minecraft/class_4877;", (String)"f_90327_");
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)gui)) instanceof GetServerDetailsTask && (realm = (RealmsServer)this.realmsTaskServerField.get(realmsTask = (GetServerDetailsTask)task)) != null && (this.latestRealm == null || realm.id != this.latestRealm.id)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
        return gui;
    }

    public boolean handleRenderTick(boolean start) {
        WorldMapSession worldmapSession;
        if (!WorldMap.loaded) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        if (!start) {
            WorldMap.glObjectDeleter.work();
        }
        boolean shouldCancelGameRender = false;
        if (mc.player != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (!start) {
                mapProcessor.onRenderProcess(mc);
                mapProcessor.resetRenderStartTime();
                Queue<Runnable> minecraftScheduledTasks = mapProcessor.getMinecraftScheduledTasks();
                Runnable task = mapProcessor.getRenderStartTimeUpdater();
                Runnable[] currentTasks = minecraftScheduledTasks.toArray(new Runnable[0]);
                minecraftScheduledTasks.clear();
                minecraftScheduledTasks.add(task);
                for (Runnable t : currentTasks) {
                    minecraftScheduledTasks.add(t);
                }
            } else {
                if (!SupportMods.vivecraft && MapProcessor.shouldSkipWorldRender()) {
                    RenderSystem.enableDepthTest();
                    mc.level.pollLightUpdates();
                    mc.level.getChunkSource().getLightEngine().runUpdates(Integer.MAX_VALUE, mc.level.isLightUpdateQueueEmpty(), true);
                    shouldCancelGameRender = true;
                }
                if (mapProcessor != null) {
                    mapProcessor.setMainValues();
                }
            }
        }
        return shouldCancelGameRender;
    }

    public void handleDrawScreen(Screen gui) {
        if (!Patreon.needsNotification() && WorldMap.isOutdated) {
            WorldMap.isOutdated = false;
        }
    }

    public void handlePlayerSetSpawnEvent(BlockPos spawn, ClientLevel world) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            mapProcessor.updateWorldSpawn(spawn, world);
        }
    }

    public void handleWorldUnload(LevelAccessor world) {
        WorldMapSession worldmapSession;
        if (Minecraft.getInstance().player != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (world == mapProcessor.mainWorld) {
                mapProcessor.onWorldUnload();
            }
        }
        if (world instanceof ServerLevel) {
            ServerLevel sw = (ServerLevel)world;
            WorldDataHandler.onServerWorldUnload(sw);
        }
    }

    public RealmsServer getLatestRealm() {
        return this.latestRealm;
    }

    public boolean handleRenderCrosshairOverlay(PoseStack matrixStack) {
        String crosshairMessage;
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession == null ? null : worldmapSession.getMapProcessor();
        String string = crosshairMessage = mapProcessor == null ? null : mapProcessor.getCrosshairMessage();
        if (crosshairMessage != null) {
            int messageWidth = Minecraft.getInstance().font.width(crosshairMessage);
            RenderSystem.disableBlend();
            Window window = Minecraft.getInstance().getWindow();
            Minecraft.getInstance().font.drawShadow(matrixStack, crosshairMessage, (float)(window.getGuiScaledWidth() / 2 - messageWidth / 2), (float)(window.getGuiScaledHeight() / 2 + 60), -1);
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GuiComponent.GUI_ICONS_LOCATION);
        }
        return false;
    }

    public boolean handleClientPlayerChatReceivedEvent(ChatType chatType, Component component, UUID sender) {
        if (component == null) {
            return false;
        }
        PlayerInfo playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(sender);
        return this.handleChatMessage(playerInfo == null ? null : playerInfo.getProfile().getName(), component);
    }

    public boolean handleClientSystemChatReceivedEvent(Component component) {
        WorldMapSession worldmapSession;
        if (component == null) {
            return false;
        }
        String textString = component.getString();
        if (textString.contains("\u00a7r\u00a7e\u00a7s\u00a7e\u00a7t\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
            worldmapSession = WorldMapSession.getCurrentSession();
            worldmapSession.getMapProcessor().setConsideringNetherFairPlayMessage(false);
            worldmapSession.getMapProcessor().setFairplayMessageReceived(false);
        }
        if (textString.contains("\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o\u00a7w\u00a7m\u00a7n\u00a7e\u00a7t\u00a7h\u00a7e\u00a7r\u00a7i\u00a7s\u00a7f\u00a7a\u00a7i\u00a7r")) {
            worldmapSession = WorldMapSession.getCurrentSession();
            worldmapSession.getMapProcessor().setConsideringNetherFairPlayMessage(true);
        }
        if (textString.contains("\u00a7f\u00a7a\u00a7i\u00a7r\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
            worldmapSession = WorldMapSession.getCurrentSession();
            worldmapSession.getMapProcessor().setFairplayMessageReceived(true);
        }
        return this.handleChatMessage(I18n.get((String)"gui.xaero_waypoint_server_shared", (Object[])new Object[0]), component);
    }

    private boolean handleChatMessage(String playerName, Component text) {
        return false;
    }

    public void handlePlayerTickStart(Player player) {
        WorldMapSession worldmapSession;
        if (player == Minecraft.getInstance().player && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            worldmapSession.getControlsHandler().handleKeyEvents();
        }
    }

    public void handleClientTickStart() {
        if (Minecraft.getInstance().player != null) {
            if (!WorldMap.loaded) {
                return;
            }
            WorldMap.crashHandler.checkForCrashes();
            WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
            if (worldmapSession != null) {
                MapProcessor mapProcessor = worldmapSession.getMapProcessor();
                mapProcessor.onClientTickStart();
            }
        }
    }

    public void handleClientRunTickStart() {
        if (Minecraft.getInstance().player != null) {
            if (!WorldMap.loaded) {
                return;
            }
            WorldMap.crashHandler.checkForCrashes();
            WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
            if (worldmapSession != null) {
                worldmapSession.getMapProcessor().getWorldDataHandler().handleRenderExecutor();
            }
        }
    }
}

