/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.minimap.tracker.system;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import xaero.common.server.radar.tracker.SyncedTrackedPlayer;
import xaero.map.mods.SupportXaeroMinimap;
import xaero.map.radar.tracker.system.ITrackedPlayerReader;

public class MinimapSyncedTrackedPlayerReader
implements ITrackedPlayerReader<SyncedTrackedPlayer> {
    private SupportXaeroMinimap minimapSupport;
    private Map<ResourceLocation, ResourceKey<Level>> cachedDimIds;

    public MinimapSyncedTrackedPlayerReader(SupportXaeroMinimap minimapSupport) {
        this.minimapSupport = minimapSupport;
        this.cachedDimIds = new HashMap<ResourceLocation, ResourceKey<Level>>();
    }

    @Override
    public UUID getId(SyncedTrackedPlayer player) {
        return player.getId();
    }

    @Override
    public double getX(SyncedTrackedPlayer player) {
        return player.getX();
    }

    @Override
    public double getY(SyncedTrackedPlayer player) {
        return player.getY();
    }

    @Override
    public double getZ(SyncedTrackedPlayer player) {
        return player.getZ();
    }

    @Override
    public ResourceKey<Level> getDimension(SyncedTrackedPlayer player) {
        if (this.minimapSupport.hasDimSwitchSupport()) {
            return player.getDimensionKey();
        }
        ResourceLocation dimLocation = player.getDimension();
        ResourceKey cachedDimId = this.cachedDimIds.get(dimLocation);
        if (cachedDimId == null) {
            cachedDimId = ResourceKey.create((ResourceKey)Registry.DIMENSION_REGISTRY, (ResourceLocation)dimLocation);
            this.cachedDimIds.put(dimLocation, (ResourceKey<Level>)cachedDimId);
        }
        return cachedDimId;
    }
}

