/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.lib.common.config.util.ConfigUtils;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.gui.ScreenBase;
import xaero.map.mods.SupportMods;
import xaero.map.world.MapWorld;

public class GuiMapTpCommand
extends ScreenBase {
    private MySmallButton confirmButton;
    private EditBox commandFormatTextField;
    private EditBox dimensionCommandFormatTextField;
    private boolean usingDefault;
    private String commandFormat;
    private String dimensionCommandFormat;
    private Component waypointCommandHint = new TranslatableComponent("gui.xaero_wm_teleport_command_waypoints_hint");

    public GuiMapTpCommand(Screen parent, Screen escape) {
        super(parent, escape, (Component)new TranslatableComponent("gui.xaero_wm_teleport_command"));
        WorldMapSession session = WorldMapSession.getCurrentSession();
        MapWorld mapWorld = session.getMapProcessor().getMapWorld();
        this.usingDefault = mapWorld.isUsingDefaultMapTeleport();
        this.commandFormat = mapWorld.getTeleportCommandFormat();
        this.dimensionCommandFormat = mapWorld.getDimensionTeleportCommandFormat();
        this.canSkipWorldRender = true;
    }

    public void init() {
        super.init();
        WorldMapSession session = WorldMapSession.getCurrentSession();
        MapWorld mapWorld = session.getMapProcessor().getMapWorld();
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        String defaultMapTeleportFormat = (String)configManager.getEffective(WorldMapProfiledConfigOptions.DEFAULT_MAP_TELEPORT_FORMAT);
        String defaultMapTeleportDimensionFormat = (String)configManager.getEffective(WorldMapProfiledConfigOptions.DEFAULT_MAP_TELEPORT_DIMENSION_FORMAT);
        this.commandFormatTextField = new EditBox(this.font, this.width / 2 - 100, this.height / 7 + 60, 200, 20, (Component)new TranslatableComponent("gui.xaero_wm_teleport_command"));
        this.commandFormatTextField.setMaxLength(500);
        this.commandFormatTextField.setValue(this.usingDefault ? defaultMapTeleportFormat : this.commandFormat);
        this.dimensionCommandFormatTextField = new EditBox(this.font, this.width / 2 - 100, this.height / 7 + 90, 200, 20, (Component)new TranslatableComponent("gui.xaero_wm_dimension_teleport_command"));
        this.dimensionCommandFormatTextField.setMaxLength(500);
        this.dimensionCommandFormatTextField.setValue(this.usingDefault ? defaultMapTeleportDimensionFormat : this.dimensionCommandFormat);
        if (this.usingDefault) {
            this.dimensionCommandFormatTextField.active = false;
            this.commandFormatTextField.active = false;
            this.commandFormatTextField.setEditable(false);
            this.dimensionCommandFormatTextField.setEditable(false);
            this.commandFormatTextField.setTextColor(-11184811);
            this.dimensionCommandFormatTextField.setTextColor(-11184811);
        } else {
            this.commandFormatTextField.setResponder(text -> {
                this.commandFormat = text;
            });
            this.dimensionCommandFormatTextField.setResponder(text -> {
                this.dimensionCommandFormat = text;
            });
        }
        this.addWidget((GuiEventListener)this.commandFormatTextField);
        this.addWidget((GuiEventListener)this.dimensionCommandFormatTextField);
        if (SupportMods.minimap()) {
            this.addRenderableWidget((GuiEventListener)new MySmallButton(0, this.width / 2 - 75, this.height / 7 + 138, (Component)new TranslatableComponent("gui.xaero_wm_teleport_command_waypoints"), b -> SupportMods.xaeroMinimap.openWaypointWorldTeleportCommandScreen((Screen)this, this.escape)));
        }
        this.confirmButton = new MySmallButton(1, this.width / 2 - 155, this.height / 6 + 168, (Component)new TranslatableComponent("gui.xaero_confirm"), b -> {
            if (this.canConfirm()) {
                if (!this.usingDefault && this.commandFormat.equals(defaultMapTeleportFormat) && this.dimensionCommandFormat.equals(defaultMapTeleportDimensionFormat)) {
                    this.usingDefault = true;
                }
                mapWorld.setTeleportCommandFormat(this.commandFormat);
                mapWorld.setDimensionTeleportCommandFormat(this.dimensionCommandFormat);
                mapWorld.setUseDefaultMapTeleport(this.usingDefault);
                mapWorld.saveConfig();
                this.goBack();
            }
        });
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        this.addRenderableWidget((GuiEventListener)new MySmallButton(2, this.width / 2 + 5, this.height / 6 + 168, (Component)new TranslatableComponent("gui.xaero_cancel"), b -> this.goBack()));
        this.addRenderableWidget((GuiEventListener)new MySmallButton(202, this.width / 2 - 75, this.height / 7 + 20, (Component)CommonComponents.optionNameValue((Component)new TranslatableComponent("gui.xaero_wm_use_default"), (Component)ConfigUtils.getDisplayForBoolean(null, (Boolean)this.usingDefault)), b -> {
            this.usingDefault = !this.usingDefault;
            this.init(this.minecraft, this.width, this.height);
        }));
        this.minecraft.keyboardHandler.setSendRepeatsToGui(true);
    }

    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partial) {
        this.renderEscapeScreen(matrixStack, mouseX, mouseY, partial);
        this.renderBackground(matrixStack);
        GuiComponent.drawCenteredString((PoseStack)matrixStack, (Font)this.font, (Component)this.title, (int)(this.width / 2), (int)20, (int)0xFFFFFF);
        if (SupportMods.minimap()) {
            GuiComponent.drawCenteredString((PoseStack)matrixStack, (Font)this.font, (Component)this.waypointCommandHint, (int)(this.width / 2), (int)(this.height / 7 + 124), (int)-5592406);
        }
        GuiComponent.drawCenteredString((PoseStack)matrixStack, (Font)this.font, (String)"{x} {y} {z} {d}", (int)(this.width / 2), (int)(this.height / 7 + 46), (int)-5592406);
        super.render(matrixStack, mouseX, mouseY, partial);
        this.commandFormatTextField.render(matrixStack, mouseX, mouseY, partial);
        this.dimensionCommandFormatTextField.render(matrixStack, mouseX, mouseY, partial);
    }

    private boolean canConfirm() {
        return this.commandFormat != null && this.commandFormat.length() > 0 && this.dimensionCommandFormat != null && this.dimensionCommandFormat.length() > 0;
    }

    public void tick() {
        super.tick();
        this.commandFormatTextField.tick();
        this.dimensionCommandFormatTextField.tick();
        this.confirmButton.active = this.canConfirm();
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        if (par1 == 257 && this.commandFormat != null && this.commandFormat.length() > 0) {
            this.confirmButton.onClick(0.0, 0.0);
        }
        return super.keyPressed(par1, par2, par3);
    }

    public void setFocused(GuiEventListener l) {
        GuiEventListener currentFocused = this.getFocused();
        if (currentFocused != null && currentFocused != l && currentFocused instanceof EditBox) {
            ((EditBox)currentFocused).setFocus(false);
        }
        super.setFocused(l);
    }
}

