/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.teleport;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.map.WorldMap;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.world.MapConnectionNode;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class MapTeleporter {
    public void teleport(Screen screen, MapWorld mapWorld, int x, int y, int z, ResourceKey<Level> d) {
        String tpCommand;
        Minecraft.getInstance().setScreen(null);
        if (Minecraft.getInstance().gameMode.canHurtPlayer()) {
            MapConnectionNode destinationMapKey;
            MapDimension destinationDim = mapWorld.getDimension(d != null ? d : Minecraft.getInstance().level.dimension());
            MapConnectionNode playerMapKey = mapWorld.getPlayerMapKey();
            if (playerMapKey == null) {
                MutableComponent messageComponent = Component.literal((String)I18n.get((String)"gui.xaero_wm_teleport_never_confirmed", (Object[])new Object[0]));
                messageComponent.setStyle(messageComponent.getStyle().withColor(ChatFormatting.RED));
                Minecraft.getInstance().gui.getChat().addMessage((Component)messageComponent);
                return;
            }
            MapConnectionNode mapConnectionNode = destinationMapKey = destinationDim == null ? null : destinationDim.getSelectedMapKeyUnsynced();
            if (!mapWorld.getMapConnections().isConnected(playerMapKey, destinationMapKey)) {
                MutableComponent messageComponent = Component.literal((String)I18n.get((String)"gui.xaero_wm_teleport_not_connected", (Object[])new Object[0]));
                messageComponent.setStyle(messageComponent.getStyle().withColor(ChatFormatting.RED));
                Minecraft.getInstance().gui.getChat().addMessage((Component)messageComponent);
                return;
            }
        }
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        boolean partialYTeleportConfig = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.PARTIAL_Y_TELEPORT);
        String string = tpCommand = d == null ? mapWorld.getEffectiveTeleportCommandFormat() : mapWorld.getEffectiveDimensionTeleportCommandFormat();
        String yString = y == Short.MAX_VALUE ? "~" : (partialYTeleportConfig ? "" + ((double)y + 0.5) : "" + y);
        tpCommand = tpCommand.replace("{x}", "" + x).replace("{y}", yString).replace("{z}", "" + z);
        if (d != null) {
            tpCommand = tpCommand.replace("{d}", d.location().toString());
        }
        Minecraft mc = Minecraft.getInstance();
        if (tpCommand.startsWith("/")) {
            if (!mc.player.commandUnsigned(tpCommand = tpCommand.substring(1))) {
                mc.player.commandSigned(tpCommand, (Component)Component.literal((String)tpCommand));
            }
        } else {
            mc.player.chatSigned(tpCommand, (Component)Component.literal((String)tpCommand));
        }
        mapWorld.setCustomDimensionId(null);
        mapWorld.getMapProcessor().checkForWorldUpdate();
    }
}

