/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.radar.tracker;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.icon.XaeroIcon;
import xaero.map.icon.XaeroIconAtlas;
import xaero.map.misc.Misc;
import xaero.map.radar.tracker.PlayerTrackerIconRenderer;
import xaero.map.radar.tracker.PlayerTrackerMapElement;

public class TrackedPlayerIconPrerenderer {
    private ImprovedFramebuffer renderFramebuffer;
    private XaeroIconAtlas lastAtlas;
    private PoseStack matrixStack = new PoseStack();
    private final PlayerTrackerIconRenderer renderer = new PlayerTrackerIconRenderer();

    public void prerender(XaeroIcon icon, Player player, int iconWidth, ResourceLocation skinTextureLocation, PlayerTrackerMapElement<?> mapElement) {
        if (this.renderFramebuffer == null) {
            this.renderFramebuffer = new ImprovedFramebuffer(icon.getTextureAtlas().getWidth(), icon.getTextureAtlas().getWidth(), false);
            GlStateManager._deleteTexture((int)this.renderFramebuffer.getColorTextureId());
            this.renderFramebuffer.setFramebufferTexture(0);
        }
        this.renderFramebuffer.bindAsMainTarget(false);
        GlStateManager._viewport((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)iconWidth, (int)iconWidth);
        this.renderFramebuffer.setFramebufferTexture(icon.getTextureAtlas().getTextureId());
        this.renderFramebuffer.checkStatus();
        if (this.lastAtlas != icon.getTextureAtlas()) {
            RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            RenderSystem.clear((int)16384, (boolean)Minecraft.ON_OSX);
            this.lastAtlas = icon.getTextureAtlas();
        }
        Matrix4f ortho = Matrix4f.orthographic((float)0.0f, (float)iconWidth, (float)0.0f, (float)iconWidth, (float)-1.0f, (float)1000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)ortho);
        PoseStack shaderMatrixStack = RenderSystem.getModelViewStack();
        shaderMatrixStack.pushPose();
        shaderMatrixStack.setIdentity();
        RenderSystem.applyModelViewMatrix();
        PoseStack matrixStack = this.matrixStack;
        matrixStack.pushPose();
        matrixStack.translate((double)(iconWidth / 2), (double)(iconWidth / 2), 0.0);
        matrixStack.scale(3.0f, 3.0f, 1.0f);
        GuiComponent.fill((PoseStack)matrixStack, (int)-5, (int)-5, (int)5, (int)5, (int)-1);
        this.renderer.renderIcon(matrixStack, player, skinTextureLocation);
        matrixStack.popPose();
        Minecraft mc = Minecraft.getInstance();
        Misc.minecraftOrtho(mc, false);
        shaderMatrixStack.popPose();
        RenderSystem.applyModelViewMatrix();
        this.renderFramebuffer.unbindWrite();
        this.renderFramebuffer.bindDefaultFramebuffer(mc);
        GlStateManager._viewport((int)0, (int)0, (int)mc.getWindow().getWidth(), (int)mc.getWindow().getHeight());
    }
}

