/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.radar.tracker;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.element.MapElementReader;
import xaero.map.element.render.ElementRenderLocation;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.dropdown.rightclick.RightClickOption;
import xaero.map.mods.SupportMods;
import xaero.map.radar.tracker.PlayerTeleporter;
import xaero.map.radar.tracker.PlayerTrackerMapElement;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderContext;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderer;

public class PlayerTrackerMapElementReader
extends MapElementReader<PlayerTrackerMapElement<?>, PlayerTrackerMapElementRenderContext, PlayerTrackerMapElementRenderer> {
    @Override
    public boolean isHidden(PlayerTrackerMapElement<?> element, PlayerTrackerMapElementRenderContext context) {
        return Minecraft.getInstance().level.dimension() != element.getDimension() && context.mapDimId != element.getDimension();
    }

    @Override
    public double getRenderX(PlayerTrackerMapElement<?> element, PlayerTrackerMapElementRenderContext context, float partialTicks) {
        if (Minecraft.getInstance().level.dimension() != element.getDimension()) {
            return element.getX() * context.mapDimDiv;
        }
        return element.getX();
    }

    @Override
    public double getRenderZ(PlayerTrackerMapElement<?> element, PlayerTrackerMapElementRenderContext context, float partialTicks) {
        if (Minecraft.getInstance().level.dimension() != element.getDimension()) {
            return element.getZ() * context.mapDimDiv;
        }
        return element.getZ();
    }

    @Override
    public int getInteractionBoxLeft(PlayerTrackerMapElement<?> element, PlayerTrackerMapElementRenderContext context, float partialTicks) {
        return -16;
    }

    @Override
    public int getInteractionBoxRight(PlayerTrackerMapElement<?> element, PlayerTrackerMapElementRenderContext context, float partialTicks) {
        return 16;
    }

    @Override
    public int getInteractionBoxTop(PlayerTrackerMapElement<?> element, PlayerTrackerMapElementRenderContext context, float partialTicks) {
        return -16;
    }

    @Override
    public int getInteractionBoxBottom(PlayerTrackerMapElement<?> element, PlayerTrackerMapElementRenderContext context, float partialTicks) {
        return 16;
    }

    @Override
    public int getRenderBoxLeft(PlayerTrackerMapElement<?> element, PlayerTrackerMapElementRenderContext context, float partialTicks) {
        return -20;
    }

    @Override
    public int getRenderBoxRight(PlayerTrackerMapElement<?> element, PlayerTrackerMapElementRenderContext context, float partialTicks) {
        return 20;
    }

    @Override
    public int getRenderBoxTop(PlayerTrackerMapElement<?> element, PlayerTrackerMapElementRenderContext context, float partialTicks) {
        return -20;
    }

    @Override
    public int getRenderBoxBottom(PlayerTrackerMapElement<?> element, PlayerTrackerMapElementRenderContext context, float partialTicks) {
        return 20;
    }

    @Override
    public int getLeftSideLength(PlayerTrackerMapElement<?> element, Minecraft mc) {
        PlayerInfo info = Minecraft.getInstance().getConnection().getPlayerInfo(element.getPlayerId());
        if (info == null) {
            return 9;
        }
        return 9 + mc.font.width(info.getProfile().getName());
    }

    @Override
    public String getMenuName(PlayerTrackerMapElement<?> element) {
        PlayerInfo info = Minecraft.getInstance().getConnection().getPlayerInfo(element.getPlayerId());
        if (info == null) {
            return "" + element.getPlayerId();
        }
        return info.getProfile().getName();
    }

    @Override
    public String getFilterName(PlayerTrackerMapElement<?> element) {
        return this.getMenuName(element);
    }

    @Override
    public int getMenuTextFillLeftPadding(PlayerTrackerMapElement<?> element) {
        return 0;
    }

    @Override
    public int getRightClickTitleBackgroundColor(PlayerTrackerMapElement<?> element) {
        return -11184641;
    }

    @Override
    public boolean shouldScaleBoxWithOptionalScale() {
        return true;
    }

    @Override
    public boolean isRightClickValid(PlayerTrackerMapElement<?> element) {
        return WorldMap.trackedPlayerRenderer.getCollector().playerExists(element.getPlayerId());
    }

    @Override
    public ArrayList<RightClickOption> getRightClickOptions(final PlayerTrackerMapElement<?> element, IRightClickableElement target) {
        ArrayList<RightClickOption> rightClickOptions = new ArrayList<RightClickOption>();
        rightClickOptions.add(new RightClickOption(this.getMenuName(element), rightClickOptions.size(), target){

            @Override
            public void onAction(Screen screen) {
            }
        });
        rightClickOptions.add(new RightClickOption("", rightClickOptions.size(), target){

            @Override
            public String getName() {
                ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
                if (!((Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.COORDINATES)).booleanValue()) {
                    return "hidden";
                }
                return String.format("X: %d, Y: %s, Z: %d", (int)Math.floor(element.getX()), (int)Math.floor(element.getY()), (int)Math.floor(element.getZ()));
            }

            @Override
            public void onAction(Screen screen) {
            }
        });
        rightClickOptions.add(new RightClickOption("gui.xaero_right_click_player_teleport", rightClickOptions.size(), target){

            @Override
            public void onAction(Screen screen) {
                WorldMapSession session = WorldMapSession.getCurrentSession();
                new PlayerTeleporter().teleportToPlayer(screen, session.getMapProcessor().getMapWorld(), element);
            }
        }.setNameFormatArgs("T"));
        if (SupportMods.pac()) {
            rightClickOptions.add(new RightClickOption("gui.xaero_right_click_player_config", rightClickOptions.size(), target){

                @Override
                public void onAction(Screen screen) {
                    SupportMods.xaeroPac.openPlayerConfigScreen(screen, screen, element);
                }

                @Override
                public boolean isActive() {
                    return Minecraft.getInstance().player.hasPermissions(2) && Minecraft.getInstance().getConnection().getPlayerInfo(element.getPlayerId()) != null;
                }
            }.setNameFormatArgs("C"));
        }
        return rightClickOptions;
    }

    @Override
    @Deprecated
    public boolean isInteractable(int location, PlayerTrackerMapElement<?> element) {
        return this.isInteractable(ElementRenderLocation.fromIndex(location), element);
    }

    @Override
    public boolean isInteractable(ElementRenderLocation location, PlayerTrackerMapElement<?> element) {
        return true;
    }
}

